//=============================================================================
// HXHackableDevices.
//=============================================================================
class HXHackableDevices extends HackableDevices
	abstract;

/***
	NOTE: this was first intended as base class for keypads,
				unused atm, but for reference what needs to be 
				changed in HackableDevices subclasses
***/


//
// Called to deal with resetting the device
//
function Tick(float deltaTime)
{
	 // reset stuff removed
   Super(ElectronicDevices).Tick(deltaTime);
}


//
// The main logic function for control panels
//
function Frob(Actor Frobber, Inventory frobWith)
{
	local Pawn P;
	local DeusExPlayer Player;
	local bool bHackIt, bDone;
	local string msg;
	local Vector X, Y, Z;
	local float dotp;

	P = Pawn(Frobber);
	Player = DeusExPlayer(P);
	bHackIt = False;
	bDone = False;
	msg = msgNotHacked;

	// make sure someone is trying to hack the device
	if (P == None)
		return;

	// Let any non-player pawn hack the device for now
	if (Player == None)
	{
		bHackIt = True;
		msg = "";
		bDone = True;
	}

	// If we are already trying to hack it, print a message
	if (bHacking)
	{
		msg = msgHacking;
		bDone = True;
	}

	if (!bDone)
	{
		// Get what's in the player's hand
		if (frobWith != None)
		{
			// check for the use of multitools
			if (bHackable && frobWith.IsA('Multitool') && (Player.SkillSystem != None))
			{
				if (hackStrength > 0.0)
				{
					// alert NPCs that I'm messing with stuff
					AIStartEvent('MegaFutz', EAITYPE_Visual);

					hackValue = Player.SkillSystem.GetSkillLevelValue(class'SkillTech');
					hackPlayer = Player;
					curTool = Multitool(frobWith);
					curTool.bBeingUsed = True;
					curTool.PlayUseAnim();
					bHacking = True;
					//Number of percentage points to remove
					numHacks = hackValue * 100;
					// HXCOOP removed
					//if (Level.Netmode != NM_Standalone)
					//   hackTime = default.hackTime / (hackValue * hackValue);
					TicksPerHack = (hackTime * 10.0) / numHacks;
					LastTickTime = Level.TimeSeconds;
					TicksSinceLastHack = 0;
					SetTimer(0.1, True);
					msg = msgHacking;
				}
				else
				{
					bHackIt = True;
					msg = msgAlreadyHacked;
				}
			}
		}
		else if (hackStrength == 0.0)
		{
			// if it's open
			bHackIt = True;
			msg = "";
		}
	}

	// give the player a message
	if ((Player != None) && (msg != ""))
		Player.ClientMessage(msg);

	// if our hands are empty, call HackAction()
	if ((Player != None) && (frobWith == None))
		HackAction(Frobber, (hackStrength == 0.0));

	// trigger the device!
	if (bHackIt)
		Super(ElectronicDevices).Frob(Frobber, frobWith);
}


defaultproperties
{
}
