//=============================================================================
// HXHumanMilitary.
//=============================================================================
class HXHumanMilitary extends HumanMilitary
	abstract;

// ----------------------------------------------------------------------
// PreBeginPlay()
// ----------------------------------------------------------------------
function PreBeginPlay()
{
	local float saveBaseEyeHeight;

	saveBaseEyeHeight = BaseEyeHeight;

	// snipped from Pawn
	//AddPawn();
	Super(Actor).PreBeginPlay();
	if ( bDeleteMe )
		return;

	// Added angular size computation - DEUS_EX STM
	MinAngularSize = tan(AngularResolution*0.5*Pi/180.0);
	MinAngularSize *= MinAngularSize;

	// Set instigator to self.
	Instigator = Self;
	DesiredRotation = Rotation;
	SightCounter = 0.2 * FRand();  //offset randomly 
	if ( Level.Game != None )
		Skill += Level.Game.Difficulty; 
	Skill = FClamp(Skill, 0, 3);
	PreSetMovement();
	
	if ( DrawScale != Default.Drawscale )
	{
		SetCollisionSize(CollisionRadius*DrawScale/Default.DrawScale, CollisionHeight*DrawScale/Default.DrawScale);
		Health = Health * DrawScale/Default.DrawScale;
	}

	if (bIsPlayer)
	{
		if (PlayerReplicationInfoClass != None)
			PlayerReplicationInfo = Spawn(PlayerReplicationInfoClass, Self,,vect(0,0,0),rot(0,0,0));
		else
			PlayerReplicationInfo = Spawn(class'PlayerReplicationInfo', Self,,vect(0,0,0),rot(0,0,0));
		InitPlayerReplicationInfo();
	}

	if (!bIsPlayer) 
	{
		if ( BaseEyeHeight == 0 )
			BaseEyeHeight = 0.8 * CollisionHeight;
		EyeHeight = BaseEyeHeight;
		if (Fatness == 0) //vary monster fatness slightly if at default
			Fatness = 120 + Rand(8) + Rand(8);
	}

	if ( menuname == "" )
		menuname = GetItemName(string(class));

	if (SelectionMesh == "")
		SelectionMesh = string(Mesh);
	// snipped from Pawn end

	BaseEyeHeight = saveBaseEyeHeight;

	// create our shadow
	CreateShadow();

	// Set our alliance
	SetAlliance(Alliance);

	// Set up callbacks
	UpdateReactionCallbacks();
}


defaultproperties
{
}
