//=============================================================================
// HXMedicalBot.
//=============================================================================
class HXMedicalBot extends MedicalBot;


// ----------------------------------------------------------------------
// PreBeginPlay()
// ----------------------------------------------------------------------
function PreBeginPlay()
{
	ScriptedPawnPreBeginPlay();
}


// ----------------------------------------------------------------------
// PawnPreBeginPlay()
// ----------------------------------------------------------------------
event PawnPreBeginPlay()
{
	//AddPawn();
	Super(Actor).PreBeginPlay();
	if ( bDeleteMe )
		return;

	// Added angular size computation - DEUS_EX STM
	MinAngularSize = tan(AngularResolution*0.5*Pi/180.0);
	MinAngularSize *= MinAngularSize;

	// Set instigator to self.
	Instigator = Self;
	DesiredRotation = Rotation;
	SightCounter = 0.2 * FRand();  //offset randomly 
	if ( Level.Game != None )
		Skill += Level.Game.Difficulty; 
	Skill = FClamp(Skill, 0, 3);
	PreSetMovement();
	
	if ( DrawScale != Default.Drawscale )
	{
		SetCollisionSize(CollisionRadius*DrawScale/Default.DrawScale, CollisionHeight*DrawScale/Default.DrawScale);
		Health = Health * DrawScale/Default.DrawScale;
	}

	if (bIsPlayer)
	{
		if (PlayerReplicationInfoClass != None)
			PlayerReplicationInfo = Spawn(PlayerReplicationInfoClass, Self,,vect(0,0,0),rot(0,0,0));
		else
			PlayerReplicationInfo = Spawn(class'PlayerReplicationInfo', Self,,vect(0,0,0),rot(0,0,0));
		InitPlayerReplicationInfo();
	}

	if (!bIsPlayer) 
	{
		if ( BaseEyeHeight == 0 )
			BaseEyeHeight = 0.8 * CollisionHeight;
		EyeHeight = BaseEyeHeight;
		if (Fatness == 0) //vary monster fatness slightly if at default
			Fatness = 120 + Rand(8) + Rand(8);
	}

	if ( menuname == "" )
		menuname = GetItemName(string(class));

	if (SelectionMesh == "")
		SelectionMesh = string(Mesh);
}


// ----------------------------------------------------------------------
// ScriptedPawnPreBeginPlay()
// ----------------------------------------------------------------------
function ScriptedPawnPreBeginPlay()
{
	local float saveBaseEyeHeight;

	// TODO:
	//
	// Okay, we need to save the base eye height right now becase it's
	// obliterated in Pawn.uc with the following:
	//
	//  EyeHeight = 0.8 * CollisionHeight; //FIXME - if all baseeyeheights set right, use them
	//  BaseEyeHeight = EyeHeight;
	//
	// This must be fixed after ECTS.

	saveBaseEyeHeight = BaseEyeHeight;

	PawnPreBeginPlay();

	BaseEyeHeight = saveBaseEyeHeight;

	// create our shadow
	CreateShadow();

	// Set our alliance
	SetAlliance(Alliance);

	// Set up callbacks
	UpdateReactionCallbacks();
}


// ----------------------------------------------------------------------
// PostBeginPlay()
//
// changed to use SP healRefreshTime (possibly no good idea?)
// ----------------------------------------------------------------------
function PostBeginPlay()
{
	Super(Robot).PostBeginPlay();

	if (IsImmobile())
		bAlwaysRelevant = True;

	lastHealTime = -healRefreshTime;
}


// ----------------------------------------------------------------------
// Frob()
//
// Invoke the Augmentation Upgrade 
//
// changed to show heal/aug menu in also in coop
// ----------------------------------------------------------------------

function Frob(Actor Frobber, Inventory frobWith)
{
	local DeusExPlayer player;
	local DeusExRootWindow root;
	local HUDMedBotAddAugsScreen winAug;
	local HUDMedBotHealthScreen  winHealth;
	local AugmentationCannister augCan;

	Super.Frob(Frobber, frobWith);

	player = DeusExPlayer(Frobber);

	if (player == None)
	return;

	// use window in SP and COOP
	root = DeusExRootWindow(player.rootWindow);
	if (root != None)
	{
		// First check to see if the player has any augmentation cannisters.
		// If so, then we'll pull up the Add Augmentations screen.  
		// Otherwise pull up the Health screen first.

		augCan = AugmentationCannister(player.FindInventoryType(Class'AugmentationCannister'));

		if (augCan != None)
		{
			winAug = HUDMedBotAddAugsScreen(root.InvokeUIScreen(Class'HUDMedBotAddAugsScreen', True));
			winAug.SetMedicalBot(Self, True);
		}
		else
		{
			winHealth = HUDMedBotHealthScreen(root.InvokeUIScreen(Class'HUDMedBotHealthScreen', True));
			winHealth.SetMedicalBot(Self, True);
		}
		root.MaskBackground(True);
	}
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
}
