//=============================================================================
// HXMenuScreenHostGame (multiplayer)
//=============================================================================

class HXMenuScreenHostGame expands MenuScreenHostGame;


// ----------------------------------------------------------------------
// BeginHost()
// ----------------------------------------------------------------------

function BeginHost()
{
	local string mapname;
	local string gametype;
	local int configservermode;   
	
	//Save all settings so that they can be read.
	SaveSettings();
	
	mapname = GetGameType();
	configservermode = int(player.ConsoleCommand("get MenuScreenHostGame ServerMode"));
	gametype = player.ConsoleCommand("get MenuScreenHostGame CurrentGameType");
	
	if (configservermode == MODE_DEDICATED)
		//player.ConsoleCommand("Relaunch " $mapname$ "?game=" $gametype$ "?-server?log=server.log");
		player.ConsoleCommand("Relaunch " $mapname$ "?game=HXCoop.HXCoopGame?-server?log=server.log");
	else
		//player.StartListenGame(mapname $ "?game=" $ gametype);
		player.StartListenGame(mapname $ "?game=HXCoop.HXCoopGame");
}


// ----------------------------------------------------------------------
// GetGameType()
// ----------------------------------------------------------------------

function string GetGameType()
{
	local HXMapList MapList;
	local string mapname;

	MapList = player.Spawn(class'HXMapList');

	if (MapList == None)
		return "";

	mapname = MapList.Maps[MapList.MapNum];

	MapList.Destroy();

	return mapname;
}

defaultproperties
{
	choices(1)=Class'HXMenuChoice_Map'
}
