//=============================================================================
// HXMutator - attempt to add working ReplaceWith
//=============================================================================
class HXMutator expands Mutator;


/*** snippet of Actor.uc
//
// Spawn an actor. Returns an actor of the specified class, not
// of class Actor (this is hardcoded in the compiler). Returns None
// if the actor could not be spawned (either the actor wouldn't fit in
// the specified location, or the actor list is full).
// Defaults to spawning at the spawner's location.
//
native(278) final function actor Spawn
(
	class<actor>      SpawnClass,
	optional actor	  SpawnOwner,
	optional name     SpawnTag,
	optional vector   SpawnLocation,
	optional rotator  SpawnRotation
);

native(262) final function SetCollision( optional bool NewColActors, optional bool NewBlockActors, optional bool NewBlockPlayers );

var(Collision) const bool bCollideActors;   // Collides with other actors.
var(Collision) bool       bCollideWorld;    // Collides with the world.
var(Collision) bool       bBlockActors;	    // Blocks other nonplayer actors.
var(Collision) bool       bBlockPlayers;    // Blocks other player actors.
var(Collision) bool       bProjTarget;      // Projectiles should potentially target this actor.
***/

/***
	modified replace to deal with dx specialities

	* DeusExCarcass - done
	* ScriptedPawn - workin' on it (I FUCKIN' HATE THIS FUCKING FUCK)
	* Mover - just omg Oo
***/
function bool ReplaceWith(actor Other, string aClassName)
{
	local Actor A;
	local class<Actor> aClass;
	local int i, j;
	local Inventory inv;
	local DeusExCarcass carc;
	
	if ( Other.IsA('Inventory') && (Other.Location == vect(0,0,0)) )
		return false;

	aClass = class<Actor>(DynamicLoadObject(aClassName, class'Class'));
	if (aClass == None)
		return false;


	// special ScriptedPawn handling
	if (Other.isA('ScriptedPawn'))
	{
		// disable collision to make A spawn and hx crash :|
		//Other.SetCollision(false, false, false);
		log("HX: disabling ScriptedPawn collision");
	}

	A = Spawn(aClass,,Other.tag, Other.Location, Other.Rotation);

	// taken from DeusEx.Mutator
	if (Other.IsA('Inventory'))
	{
		if (Inventory(Other).MyMarker != None)
		{
			Inventory(Other).MyMarker.markedItem = Inventory(A);
			if (Inventory(A) != None)
			{
				Inventory(A).MyMarker = Inventory(Other).MyMarker;
				A.SetLocation(A.Location 
					+ (A.CollisionHeight - Other.CollisionHeight) * vect(0,0,1));
			}
			Inventory(Other).MyMarker = None;
		}
		else if (A.IsA('Inventory'))
		{
			Inventory(A).bHeldItem = true;
			Inventory(A).Respawntime = 0.0;
		}
	}


	// move inventory of carcasses
	if (Other.IsA('DeusExCarcass') && A != None && A.isA('DeusExCarcass'))
	{
		/***
			initial inventory should be the same as actual inventory, coz in HXCoop only
			existing unfrobed carcasses are replaced this way
		***/

		carc = DeusExCarcass(Other);

		for (i=0; i<8; i++)
		{
			if ((carc.InitialInventory[i].inventory != None) && (carc.InitialInventory[i].count > 0))
			{
				for (j=0; j < carc.InitialInventory[i].count; j++)
				{
					inv = spawn(carc.InitialInventory[i].inventory, self);
					if (inv != None)
					{
						inv.bHidden = True;
						inv.SetPhysics(PHYS_None);
						
						DeusExCarcass(A).AddInventory(inv);
					}
				}
			}
		}
	}
	
	else if (Other.isA('HackableDevices') && A != None && A.isA('HackableDevices'))
	{
		//CopyHackableDevicesVars(HackableDevices(Other), HackableDevices(A));

		if (Other.isA('Keypad') && A.isA('Keypad'))
			CopyKeypadVars(Keypad(Other), Keypad(A));

	}
	
	else if (Other.isA('Brush') && A != None && A.isA('Brush'))
	{
		CopyBrushVars(Brush(Other), Brush(A));
		log("HX: Copying Brush Vars");

		if (Other.isA('Mover') && A.isA('Mover'))
		{
			CopyMoverVars(Mover(Other), Mover(A));
			log("HX: Copying Mover Vars");

			if (Other.isA('DeusExMover') && A.isA('DeusExMover'))
			{
				CopyDeusExMoverVars(DeusExMover(Other), DeusExMover(A));
				log("HX: Copying DeusExMover Vars");
			}
		}
	}

	// ok now to the *real* **hard** ***fuckin'*** stuff
	else if (Other.isA('ScriptedPawn') /* && A != None && A.isA('ScriptedPawn')*/)
	{
		// i hate this (TM)

		// first start with log output
		log("HX: HXMutator.ReplaceWith:");
		log("HX:  doing ScriptedPawn replace");
		log("HX:   Other.Location:" $ Other.Location); 
		log("HX:   Other.Rotation:" $ Other.Rotation);
		if (A == None)
		{
			log("A == None");
		}
		else 
		{
			log("HX:   A.Location:" $ A.Location); 
			log("HX:   A.Rotation:" $ A.Rotation);
		}
	}

	if (A != None)
	{
		A.event = Other.event;
		A.tag = Other.tag;
		return true;
	}

	return false;
}

function CopyAnimalVars(Animal src, Animal dst)
{
/***
	TODO - if needed (why replace fuckin' animals?
				 there is no netmode specific stuff in there)
***/
}

function CopyBrushVars(Brush src, Brush dst)
{
	src.PostPivot = dst.PostPivot;
	src.MainScale = dst.MainScale;
	src.PostScale = dst.PostScale;
	src.TempScale = dst.TempScale;
	src.BrushColor = dst.BrushColor;
	src.PolyFlags = dst.PolyFlags;
	src.bColored = dst.bColored;
}

function CopyDeusExMoverVars(DeusExMover src, DeusExMover dst)
{
	dst.bOneWay = src.bOneWay;
	dst.bLocked = src.bLocked;
	dst.bPickable = src.bPickable;
	dst.lockStrength = src.lockStrength;
	dst.initiallockStrength = src.initiallockStrength;
	dst.bInitialLocked = src.bInitialLocked;
	dst.bBreakable = src.bBreakable;
	dst.doorStrength = src.doorStrength;
	dst.KeyIDNeeded = src.KeyIDNeeded;
	dst.bHighlight = src.bHighlight;
	dst.bFrobbable = src.bFrobbable;
	dst.minDamageThreshold = src.minDamageThreshold;
	dst.bDestroyed = src.bDestroyed;
	dst.NumFragments = src.NumFragments;
	dst.FragmentScale = src.FragmentScale;
	dst.FragmentSpread = src.FragmentSpread;
	dst.FragmentClass = src.FragmentClass;
	dst.FragmentTexture = src.FragmentTexture;
	dst.bFragmentTranslucent = src.bFragmentTranslucent;
	dst.bFragmentUnlit = src.bFragmentUnlit;
	dst.ExplodeSound1 = src.ExplodeSound1;
	dst.ExplodeSound2 = src.ExplodeSound2;
	dst.bDrawExplosion = src.bDrawExplosion;
	dst.bIsDoor = src.bIsDoor;
	dst.TimeSinceReset = src.TimeSinceReset;
	dst.TimeToReset = src.TimeSinceReset;

	// probably unneeded
	//dst.bPicking = src.bPicking;
	//dst.pickValue = src.pickValue;
	//dst.pickTime = src.pickTime;
	//dst.numPicks = src.numPicks;
	//dst.TicksSinceLastPick = src.TicksSinceLastPick;
	//dst.TicksPerPick = src.TicksPerPick;
	//dst.LastTickTime = src.LastTickTime;
	//dst.pickPlayer = src.pickPlayer;
	//dst.curPick = src.curPick;
}

function CopyHackableDevicesVars(HackableDevices src, HackableDevices dst)
{
	dst.bHackable = src.bHackable;
	dst.hackStrength = src.hackStrength;
	dst.initialhackStrength = src.initialhackStrength;
	dst.UnTriggerEvent[0] = src.UnTriggerEvent[0];
	dst.UnTriggerEvent[1] = src.UnTriggerEvent[1];
	dst.UnTriggerEvent[2] = src.UnTriggerEvent[2];
	dst.UnTriggerEvent[3] = src.UnTriggerEvent[3];
	dst.TimeSinceReset = src.TimeSinceReset;
	dst.TimeToReset = src.TimeToReset;

	// probably unneeded
	//dst.bHacking = src.bHacking;
	//dst.hackValue = src.hackValue;
	//dst.hackTime = src.hackTime;
	//dst.numHacks = src.numHacks;
	//dst.TicksSinceLastHack = src.TicksSinceLastHack;
	//dst.TicksPerHack = src.TicksPerHack;
	//dst.LastTickTime = src.LastTickTime;
	//dst.hackPlayer = src.hackPlayer;
	//dst.curTool = src.curTool;
}

function CopyKeypadVars(Keypad src, Keypad dst)
{
	dst.validCode = src.validCode;
	dst.bToggleLock = src.bToggleLock;
	dst.FailEvent = src.FailEvent;

	// probably unneeded
	//dst.successSound = src.successSound;
	//dst.failureSound = src.failureSound;
	//dst.keypadwindow = src.keypadwindow;
}

function CopyMoverVars(Mover src, Mover dst)
{
	local int i;

	dst.MoveTime = src.MoveTime;
	dst.StayOpenTime = src.StayOpenTime;
	dst.OtherTime = src.OtherTime;
	dst.EncroachDamage = src.EncroachDamage;

	dst.bTriggerOnceOnly = src.bTriggerOnceOnly;
	dst.bSlave = src.bSlave;
	dst.bUseTriggered = src.bUseTriggered;
	dst.bDamageTriggered = src.bDamageTriggered;
	dst.bDynamicLightMover = src.bDynamicLightMover;
	dst.PlayerBumpEvent = src.PlayerBumpEvent;
	dst.BumpEvent = src.BumpEvent;
	dst.SavedTrigger = src.SavedTrigger;
	dst.DamageThreshold = src.DamageThreshold;
	dst.numTriggerEvents = src.numTriggerEvents;
	dst.Leader = src.Leader;
	dst.Follower = src.Follower;
	dst.ReturnGroup = src.ReturnGroup;
	dst.DelayTime = src.DelayTime;

	dst.OpeningSound = src.OpeningSound;
	dst.OpenedSound = src.OpenedSound;
	dst.ClosingSound = src.ClosingSound;
	dst.ClosedSound = src.ClosedSound;
	dst.MoveAmbientSound = src.MoveAmbientSound;

	for (i = 0; i < 8; i++)
	{
		dst.KeyPos[i] = src.KeyPos[i];
		dst.KeyRot[i] = src.KeyRot[i];
	}

	dst.BasePos = src.BasePos;
	dst.OldPos = src.OldPos;
	dst.OldPrePivot = src.OldPrePivot;
	dst.SavedPos = src.SavedPos;
	dst.BaseRot = src.BaseRot;
	dst.OldRot = src.OldRot;
	dst.SavedRot = src.SavedRot;

	dst.myMarker = src.myMarker;
	dst.TriggerActor = src.TriggerActor;
	dst.TriggerActor2 = src.TriggerActor2;
	dst.WaitingPawn = src.WaitingPawn;
	dst.bOpening = src.bOpening;
	dst.bDelaying = src.bDelaying;
	dst.bClientPause = src.bClientPause;
	dst.bPlayerOnly = src.bPlayerOnly;
	dst.RecommendedTrigger = src.RecommendedTrigger;

	dst.SimOldPos = src.SimOldPos;
	dst.SimOldRotPitch = src.SimOldRotPitch;
	dst.SimOldRotYaw = src.SimOldRotYaw;
	dst.SimOldRotRoll = src.SimOldRotRoll;
	dst.SimInterpolate = src.SimInterpolate;
	dst.RealPosition = src.RealPosition;
	dst.RealRotation = src.RealRotation;
	dst.ClientUpdate = src.ClientUpdate;
}

function CopyScriptedPawnVars(ScriptedPawn src, ScriptedPawn dst)
{
	// TODO - copy all these fuckin' variables (lots of dump work)
}




defaultproperties
{
}
