//=============================================================================
// HXSecurityCamera. NOTE: redo from scratsh
//=============================================================================
class HXSecurityCamera extends SecurityCamera;


//
// The main logic function for control panels
//
function Frob(Actor Frobber, Inventory frobWith)
{
	local Pawn P;
	local DeusExPlayer Player;
	local bool bHackIt, bDone;
	local string msg;
	local Vector X, Y, Z;
	local float dotp;

	P = Pawn(Frobber);
	Player = DeusExPlayer(P);
	bHackIt = False;
	bDone = False;
	msg = msgNotHacked;

	// make sure someone is trying to hack the device
	if (P == None)
		return;

	// Let any non-player pawn hack the device for now
	if (Player == None)
	{
		bHackIt = True;
		msg = "";
		bDone = True;
	}

	// If we are already trying to hack it, print a message
	if (bHacking)
	{
		msg = msgHacking;
		bDone = True;
	}

	if (!bDone)
	{
		// Get what's in the player's hand
		if (frobWith != None)
		{
			// check for the use of multitools
			if (bHackable && frobWith.IsA('Multitool') && (Player.SkillSystem != None))
			{
				if (hackStrength > 0.0)
				{
					// alert NPCs that I'm messing with stuff
					AIStartEvent('MegaFutz', EAITYPE_Visual);

					hackValue = Player.SkillSystem.GetSkillLevelValue(class'SkillTech');
					hackPlayer = Player;
					curTool = Multitool(frobWith);
					curTool.bBeingUsed = True;
					curTool.PlayUseAnim();
					bHacking = True;
					//Number of percentage points to remove
					numHacks = hackValue * 100;
					TicksPerHack = (hackTime * 10.0) / numHacks;
					LastTickTime = Level.TimeSeconds;
					TicksSinceLastHack = 0;
					SetTimer(0.1, True);
					msg = msgHacking;
				}
				else
				{
					bHackIt = True;
					msg = msgAlreadyHacked;
				}
			}
		}
		else if (hackStrength == 0.0)
		{
			// if it's open
			bHackIt = True;
			msg = "";
		}
	}

	// give the player a message
	if ((Player != None) && (msg != ""))
		Player.ClientMessage(msg);

	// if our hands are empty, call HackAction()
	if ((Player != None) && (frobWith == None))
		HackAction(Frobber, (hackStrength == 0.0));

	// trigger the device!
	if (bHackIt)
		Super(ElectronicDevices).Frob(Frobber, frobWith);
}


function HackAction(Actor Hacker, bool bHacked)
{
	local ComputerSecurity CompOwner;
	local ComputerSecurity TempComp;
	local AutoTurret turret;
	local name Turrettag;
	local int ViewIndex;

	if (bConfused)
		return;

	Super(HackableDevices).HackAction(Hacker, bHacked);

	if (bHacked)
	{
		if (bActive)
			UnTrigger(Hacker, Pawn(Hacker));
		else
			Trigger(Hacker, Pawn(Hacker));
	}
}


function Tick(float deltaTime)
{
	local float ang;
	local Rotator rot;
	local DeusExPlayer curplayer;

	Super(ElectronicDevices).Tick(deltaTime);

	curTarget = None;

   // if this camera is not active, get out
	if (!bActive)
	{
      // DEUS_EX AMSD For multiplayer
      ReplicatedRotation = DesiredRotation;

		MultiSkins[2] = Texture'BlackMaskTex';
		return;
	}

	// if we've been EMP'ed, act confused
	if (bConfused)
	{
		confusionTimer += deltaTime;

		// pick a random facing at random
		if (confusionTimer % 0.25 > 0.2)
		{
			DesiredRotation.Pitch = origRot.Pitch + 0.5*swingAngle - Rand(swingAngle);
			DesiredRotation.Yaw = origRot.Yaw + 0.5*swingAngle - Rand(swingAngle);
		}

		if (confusionTimer > confusionDuration)
		{
			bConfused = False;
			confusionTimer = 0;
			confusionDuration = Default.confusionDuration;
			LightHue = 80;
			MultiSkins[2] = Texture'GreenLightTex';
			SoundPitch = 64;
			DesiredRotation = origRot;
		}

		return;
	}

	// check the player's visibility every 0.1 seconds
	if (!bNoAlarm)
	{
		playerCheckTimer += deltaTime;

		if (playerCheckTimer > 0.1)
		{
			playerCheckTimer = 0;
         if (Level.NetMode == NM_Standalone)
            CheckPlayerVisibility(DeusExPlayer(GetPlayerPawn()));
         else
         {
            curPlayer = DeusExPlayer(AcquireMultiplayerTarget());
            if (curPlayer != None)
               CheckPlayerVisibility(curPlayer);
         }
		}
	}

	// forget about the player after a set amount of time
	if (bPlayerSeen)
	{
		// if the player has been seen, but the camera hasn't triggered yet,
		// provide some feedback to the player (light and sound)
		if (!bEventTriggered)
		{
			triggerTimer += deltaTime;

			if (triggerTimer % 0.5 > 0.4)
			{
				LightHue = 0;
				MultiSkins[2] = Texture'RedLightTex';
				PlaySound(Sound'Beep6',,,, 1280);
			}
			else
			{
				LightHue = 80;
				MultiSkins[2] = Texture'GreenLightTex';
			}
		}

		if (lastSeenTimer < memoryTime)
			lastSeenTimer += deltaTime;
		else
		{
			lastSeenTimer = 0;
			bPlayerSeen = False;

			// untrigger the event
			TriggerEvent(False);
		}

		return;
	}

	swingTimer += deltaTime;
	MultiSkins[2] = Texture'GreenLightTex';

	// swing back and forth if all is well
	if (bSwing && !bTrackPlayer)
	{
		ang = 2 * Pi * swingTimer / swingPeriod;
		rot = origRot;
		rot.Yaw += Sin(ang) * swingAngle;
		DesiredRotation = rot;
	}

   // DEUS_EX AMSD For multiplayer
   ReplicatedRotation = DesiredRotation;
}


function BeginPlay()
{
	Super(ElectronicDevices).BeginPlay();

	origRot = Rotation;
	DesiredRotation = origRot;

	playerLocation = Location;
}


defaultproperties
{
}
