//=============================================================================
// HXExtDeusExMPGame.
//
// modified DeusExMPGame to avoid Level.PawnList runnaway loop 
// after Pawn replacing
//=============================================================================
class HXExtDeusExMPGame expands DeusExMPGame;

var class<DeusExPlayer> OverrideSpawnClass;


// ----------------------------------------------------------------------
// Login()
// ----------------------------------------------------------------------
event PlayerPawn Login
(
	string Portal,
	string Options,
	out string Error,
	class<playerpawn> SpawnClass
)
{
	return DeusExMPGameLogin(Portal, Options, Error, SpawnClass);
}


// ----------------------------------------------------------------------
// PostLogin()
// ----------------------------------------------------------------------
event PostLogin(playerpawn NewPlayer)
{
	DeusExMPGamePostLogin(NewPlayer);
}


// ----------------------------------------------------------------------
// BroadcastMessage()
// note: maybe check some flag later if the game startup is finished
//       and use Level.PawnList again (might be faster)
// ----------------------------------------------------------------------
event BroadcastMessage( coerce string Msg, optional bool bBeep, optional name Type )
{
	//local Pawn P;
	local PlayerPawn P;

	if (Type == '')
		Type = 'Event';

//	if ( Level.Game.AllowsBroadcast(self, Len(Msg)) )
	//	for( P=Level.PawnList; P!=None; P=P.nextPawn )
		//	if( P.bIsPlayer || P.IsA('MessagingSpectator') )

	// HX_EXT use AllActors and message PlayerPawns instead of looking at bIsPlayer
	// (should have exactly the same effect)
	// note: the check for MessagingSpectator was useless, coz also bIsPlayer was set
	foreach AllActors(class'PlayerPawn', P)
		P.ClientMessage( Msg, Type, bBeep );
}


// ----------------------------------------------------------------------
// EvaluatePlayerStart()
// ----------------------------------------------------------------------
function float EvaluatePlayerStart(Pawn Player, PlayerStart PointToEvaluate, optional byte InTeam)
{
	local bool bTooClose;
	local DeusExPlayer OtherPlayer;
	local float Dist;

	bTooClose = False;

	// HX_EXT: changed PawnList to AllActors
	foreach AllActors(class'DeusExPlayer', OtherPlayer)
	{
		Dist = VSize(OtherPlayer.Location - PointToEvaluate.Location);
		if (VSize(OtherPlayer.Location - PointToEvaluate.Location) < 100.0)
		{
			bTooClose = TRUE;
		}
	}

	if (bTooClose)
		return -100000;
	else
		return FRand();
}


// ----------------------------------------------------------------------
// GameInfoLogin()
// ----------------------------------------------------------------------
event playerpawn GameInfoLogin
(
	string Portal,
	string Options,
	out string Error,
	class<playerpawn> SpawnClass
)
{
	local NavigationPoint StartSpot;
	local PlayerPawn      NewPlayer, TestPlayer;
	local Pawn            PawnLink;
	local string          InName, InPassword, InSkin, InFace, InChecksum;
	local byte            InTeam;

	local HXExtAdminPasswordRetriever BadBoy;
	local string DirtyAdminPassword;

	BadBoy = new class'HXExtAdminPasswordRetriever';
	DirtyAdminPassword = BadBoy.GetAdminPassword(self);
	
	// Make sure there is capacity. (This might have changed since the PreLogin call).
	if ( Level.NetMode != NM_Standalone )
	{
		if ( ClassIsChildOf(SpawnClass, class'Spectator') )
		{
			if ( (NumSpectators >= MaxSpectators)
				&& ((Level.NetMode != NM_ListenServer) || (NumPlayers > 0)) )
			{
				Error=MaxedOutMessage;
				return None;
			}
		}		
		else if ( (MaxPlayers>0) && (NumPlayers>=MaxPlayers) )
		{
			Error=MaxedOutMessage;
			return None;
		}
	}

	// Get URL options.
	InName     = Left(ParseOption ( Options, "Name"), 20);
	InTeam     = GetIntOption( Options, "Team", 0 ); // default to "no team"
	InPassword = ParseOption ( Options, "Password" );
	InSkin	   = ParseOption ( Options, "Skin"    );
	InFace     = ParseOption ( Options, "Face"    );
	InChecksum = ParseOption ( Options, "Checksum" );

	log( "Login:" @ InName );
	if( InPassword != "" )
		log( "Password"@InPassword );
	 
	// Find a start spot.
	StartSpot = FindPlayerStart( None, InTeam, Portal );

	if( StartSpot == None )
	{
		Error = FailedPlaceMessage;
		return None;
	}

	// Try to match up to existing unoccupied player in level,
	// for savegames and coop level switching.

	// HX_EXT: changed PawnList to AllActors
	foreach AllActors(class'PlayerPawn', TestPlayer)
	{
	//for( PawnLink=Level.PawnList; PawnLink!=None; PawnLink=PawnLink.NextPawn )
	//{
		//TestPlayer = PlayerPawn(PawnLink);
		if
		(/*	TestPlayer!=None
		&&	*/TestPlayer.Player==None 
		&&  TestPlayer.PlayerReplicationInfo != None
		&&  TestPlayer.bIsPlayer
		&&	TestPlayer.PlayerReplicationInfo.PlayerName != class'PlayerReplicationInfo'.default.PlayerName
		)
		{
			if
			(	(Level.NetMode==NM_Standalone)
			||	(TestPlayer.PlayerReplicationInfo.PlayerName~=InName && TestPlayer.Password~=InPassword) )
			{
				// Found matching unoccupied player, so use this one.
				NewPlayer = TestPlayer;
				break;
			}
		}
	}

	// In not found, spawn a new player.
	if( NewPlayer==None )
	{
		// Make sure this kind of player is allowed.
		if ( (bHumansOnly || Level.bHumansOnly) && !SpawnClass.Default.bIsHuman
			&& !ClassIsChildOf(SpawnClass, class'Spectator') )
			SpawnClass = DefaultPlayerClass;

		NewPlayer = Spawn(SpawnClass,,,StartSpot.Location,StartSpot.Rotation);
		if( NewPlayer!=None )
			NewPlayer.ViewRotation = StartSpot.Rotation;
	}

	// Handle spawn failure.
	if( NewPlayer == None )
	{
		log("Couldn't spawn player at "$StartSpot);
		Error = FailedSpawnMessage;
		return None;
	}

	NewPlayer.static.SetMultiSkin(NewPlayer, InSkin, InFace, InTeam);

	// Set the player's ID.
	NewPlayer.PlayerReplicationInfo.PlayerID = CurrentID++;

	// Init player's information.
	NewPlayer.ClientSetRotation(NewPlayer.Rotation);
	if( InName=="" )
		InName=DefaultPlayerName;
	if( Level.NetMode!=NM_Standalone || NewPlayer.PlayerReplicationInfo.PlayerName==DefaultPlayerName )
		ChangeName( NewPlayer, InName, false );

	// Change player's team.
	if ( !ChangeTeam(newPlayer, InTeam) )
	{
		Error = FailedTeamMessage;
		return None;
	}

	if( NewPlayer.IsA('Spectator') && (Level.NetMode == NM_DedicatedServer) )
		NumSpectators++;

	// Init player's administrative privileges
	NewPlayer.Password = InPassword;
	NewPlayer.bAdmin = DirtyAdminPassword!="" && caps(InPassword)==caps(DirtyAdminPassword);
	if( NewPlayer.bAdmin )
		log( "Administrator logged in!" );

	// Init player's replication info
	NewPlayer.GameReplicationInfo = GameReplicationInfo;

	// If we are a server, broadcast a welcome message.
	if( Level.NetMode==NM_DedicatedServer || Level.NetMode==NM_ListenServer )
		BroadcastMessage( NewPlayer.PlayerReplicationInfo.PlayerName$EnteredMessage, false );

	// Teleport-in effect.
	StartSpot.PlayTeleportEffect( NewPlayer, true );

	// Log it.
	if ( LocalLog != None )
		LocalLog.LogPlayerConnect(NewPlayer);
	if ( WorldLog != None )
		WorldLog.LogPlayerConnect(NewPlayer, InChecksum);

	if ( !NewPlayer.IsA('Spectator') )
		NumPlayers++;

	return newPlayer;
}


// ----------------------------------------------------------------------
// GameInfoPostLogin()
// ----------------------------------------------------------------------
event GameInfoPostLogin( playerpawn NewPlayer )
{
	//local Pawn P;
	local PlayerPawn P;

	// Start player's music.
	NewPlayer.ClientSetMusic( Level.Song, Level.SongSection, Level.CdTrack, MTRAN_Fade );
	if ( Level.NetMode != NM_Standalone )
	{
		//for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			//if ( P.bIsPlayer && (P != NewPlayer) )
			//{
				//if ( P.bIsMultiSkinned )
					//NewPlayer.ClientReplicateSkins(P.MultiSkins[0], P.MultiSkins[1], P.MultiSkins[2], P.MultiSkins[3]);
				//else
					//NewPlayer.ClientReplicateSkins(P.Skin);	
					
				//if ( (P.PlayerReplicationInfo != None) && P.PlayerReplicationInfo.bWaitingPlayer && P.IsA('PlayerPawn') )
				//{
					//if ( NewPlayer.bIsMultiSkinned )
						//PlayerPawn(P).ClientReplicateSkins(NewPlayer.MultiSkins[0], NewPlayer.MultiSkins[1], NewPlayer.MultiSkins[2], NewPlayer.MultiSkins[3]);
					//else
						//PlayerPawn(P).ClientReplicateSkins(NewPlayer.Skin);	
				//}						
			//}
		// replicate skins
		foreach AllActors(class'PlayerPawn', P)
		{
			if (P != NewPlayer)
			{
				if ( P.bIsMultiSkinned )
					NewPlayer.ClientReplicateSkins(P.MultiSkins[0], P.MultiSkins[1], P.MultiSkins[2], P.MultiSkins[3]);
				else
					NewPlayer.ClientReplicateSkins(P.Skin);	
				
				if ( (P.PlayerReplicationInfo != None) && P.PlayerReplicationInfo.bWaitingPlayer)
				{
					if ( NewPlayer.bIsMultiSkinned )
						P.ClientReplicateSkins(NewPlayer.MultiSkins[0], NewPlayer.MultiSkins[1], NewPlayer.MultiSkins[2], NewPlayer.MultiSkins[3]);
					else
						P.ClientReplicateSkins(NewPlayer.Skin);	
				}						
			}
		}
	}
}


// ----------------------------------------------------------------------
// DeusExGameInfoLogin()
// ----------------------------------------------------------------------
event playerpawn DeusExGameInfoLogin
(
	string Portal,
	string Options,
	out string Error,
	class<playerpawn> SpawnClass
)
{
	local DeusExPlayer player;
	local NavigationPoint StartSpot;
	local byte InTeam;
	local DumpLocation dump;

	//DEUS_EX AMSD In non multiplayer games, force JCDenton.
	if (!ApproveClass(SpawnClass))
	{
		// HX_EXT: allow overide of SpawnClass
		SpawnClass = OverrideSpawnClass;
	}

	player = DeusExPlayer(GameInfoLogin(Portal, Options, Error, SpawnClass));

	// If we're traveling across a map on the same mission, 
	// nuke the player's crap and 

	if ((player != None) && (!HasOption(Options, "Loadgame")))
	{
		player.ResetPlayerToDefaults();

		dump = player.CreateDumpLocationObject();

		if ((dump != None) && (dump.HasLocationBeenSaved()))
		{
			dump.LoadLocation();

			player.Pause();
			player.SetLocation(dump.currentDumpLocation.Location);
			player.SetRotation(dump.currentDumpLocation.ViewRotation);
			player.ViewRotation = dump.currentDumpLocation.ViewRotation;
			player.ClientSetRotation(dump.currentDumpLocation.ViewRotation);

			CriticalDelete(dump);
		}
		else
		{
			InTeam    = GetIntOption( Options, "Team", 0 ); // Multiplayer now, defaults to Team_Unatco=0
         if (Level.NetMode == NM_Standalone)			
            StartSpot = FindPlayerStart( None, InTeam, Portal );
         else
            StartSpot = FindPlayerStart( Player, InTeam, Portal );

			player.SetLocation(StartSpot.Location);
			player.SetRotation(StartSpot.Rotation);
			player.ViewRotation = StartSpot.Rotation;
			player.ClientSetRotation(player.Rotation);
		}
	}
	return player;
}


// ----------------------------------------------------------------------
// DeusExMPGameLogin()
// ----------------------------------------------------------------------
event PlayerPawn DeusExMPGameLogin
(
	string Portal,
	string Options,
	out string Error,
	class<playerpawn> SpawnClass
)
{
	local PlayerPawn newPlayer;
	local DeusExPlayer dxPlayer;

	if ((MaxPlayers > 0) && (NumPlayers >= MaxPlayers) )
	{
		Error = TooManyPlayers;
		return None;
	}

	newPlayer = DeusExGameInfoLogin(Portal, Options, Error, SpawnClass);

	newPlayer.bAutoActivate = true;

	return newPlayer;
}


// ----------------------------------------------------------------------
// DeusExMPGamePostLogin()
// ----------------------------------------------------------------------
event DeusExMPGamePostLogin(playerpawn NewPlayer)
{
   local DeusExPlayer DXPlayer;

   DXPlayer = DeusExPlayer(NewPlayer);

   log("class of new player is "$DXPlayer.Class$", class of game is "$Class$".");
   // DEUS_EX AMSD Setup abilities now called when server syncs up with options.
	//   SetupAbilities(DXPlayer);

	// MB I tried putting this in postbeginplay and postpostbeginplay, but PlayerIsListenClient failed to do the right thing at that point
   if ( DXPlayer.PlayerIsListenClient() )
   {
		DXPlayer.CreatePlayerTracker();
		if (DXPlayer.ThemeManager == NONE)
		{
		  DXPlayer.CreateColorThemeManager();
		  DXPlayer.ThemeManager.SetOwner( DXPlayer );
		  DXPlayer.ThemeManager.SetCurrentHUDColorTheme(DXPlayer.ThemeManager.GetFirstTheme(1));		
		  DXPlayer.ThemeManager.SetCurrentMenuColorTheme(DXPlayer.ThemeManager.GetFirstTheme(0)); 
		  DXPlayer.ThemeManager.SetMenuThemeByName(DXPlayer.MenuThemeName);
		  DXPlayer.ThemeManager.SetHUDThemeByName(DXPlayer.HUDThemeName);
		  DeusExRootWindow(DXPlayer.rootWindow).ChangeStyle();
		}
		DXPlayer.ReceiveFirstOptionSync(DXPlayer.AugPrefs[0], DXPlayer.AugPrefs[1], DXPlayer.AugPrefs[2], DXPlayer.AugPrefs[3], DXPlayer.AugPrefs[4]);
      DXPlayer.ReceiveSecondOptionSync(DXPlayer.AugPrefs[5], DXPlayer.AugPrefs[6], DXPlayer.AugPrefs[7], DXPlayer.AugPrefs[8]);
		DXPlayer.ShieldStatus = SS_Off;
   }
   GameInfoPostLogin(NewPlayer);
}


// ----------------------------------------------------------------------
// defaultproperties
// ----------------------------------------------------------------------
defaultproperties
{
	OverrideSpawnClass=class'JCDentonMale'
}
