 //=============================================================================
// HXExtMutator.
//=============================================================================
class HXExtMutator expands Mutator
	native;

native(2300) final function UpdateMoverWith(Mover src, Mover dst); // exchanges model of mover and Brush / Mover vars

// ----------------------------------------------------------------------
// ReplaceWith()
// ----------------------------------------------------------------------
function bool ReplaceWith(actor Other, string aClassName)
{
	local Actor A;
	local class<Actor> aClass;
	local Inventory Inv;
	local Pawn Owner;

	// taken from Engine.Mutator :: Comment: Hugh? Item in Inventory?
	if (Other.IsA('Inventory') && (Other.Location == vect(0,0,0)))
		return false;

	// special ScriptedPawn handling
	if (Other.isA('ScriptedPawn'))
		return ReplaceScriptedPawnWith(ScriptedPawn(Other), aClassName);

	aClass = class<Actor>(DynamicLoadObject(aClassName, class'Class'));
	if (aClass == None)
		return false;

	A = Spawn(aClass,,Other.tag, Other.Location, Other.Rotation);

	if (A == None)
		return false;

	if (Other.IsA('DeusExCarcass') && A != None && A.isA('DeusExCarcass'))
		UpdateDeusExCarcassWith(DeusExCarcass(Other), DeusExCarcass(A));
	else if (Other.isA('HackableDevices') && A != None && A.isA('HackableDevices'))
		UpdateHackableDevicesWith(HackableDevices(Other), HackableDevices(A));
	else if (Other.isA('DeusExMover') && A != None && A.isA('DeusExMover'))
		UpdateDeusExMoverWith(DeusExMover(Other), DeusExMover(A));
	else /*if (Other.isA('Inventory'))
	{
		Inv = Inventory(Other);

		if (Inv.Owner != None && Inv.Owner.isA('Pawn'))
		{
			Owner = Pawn(Inv.Owner);
			Owner.DeleteInventory(inv);

			if (Owner.Weapon == Other)
				Owner.Weapon = Weapon(A);
			if (Owner.SelectedItem == Other)
				Owner.SelectedItem = Inventory(A);

			Owner.AddInventory(Inventory(A));
		}
	}*/

	/*
	if (Other.IsA('Inventory'))
	{
		if (Inventory(Other).MyMarker != None)
		{
			Inventory(Other).MyMarker.markedItem = Inventory(A);
			if (Inventory(A) != None)
			{
				Inventory(A).MyMarker = Inventory(Other).MyMarker;
				A.SetLocation(A.Location 
					+ (A.CollisionHeight - Other.CollisionHeight) * vect(0,0,1));
			}
			Inventory(Other).MyMarker = None;
		}
		else if (A.IsA('Inventory'))
		{
			Inventory(A).bHeldItem = true;
			Inventory(A).Respawntime = 0.0;
		}
	}
	*/

	A.event = Other.event;
	A.tag = Other.tag;
	return true;
}


// ----------------------------------------------------------------------
// ReplaceScriptedPawnWith()
// ----------------------------------------------------------------------
function bool ReplaceScriptedPawnWith(ScriptedPawn Other, string aClassName)
{
	local ScriptedPawn A;
	local class<Actor> aClass;
	local Inventory Inv;
	local int i;

	aClass = class<Actor>(DynamicLoadObject(aClassName, class'Class'));
	if (aClass == None)
	{
		log("HXExtMutator: Could not dynamic load class string");
		return false;
	}

	Other.SetCollision(false, false, false);
	A = ScriptedPawn(Spawn(aClass,,Other.tag, Other.Location, Other.Rotation));

	if (A == None)
	{
		log("HXExtMutator: Spawning ScriptedPawn Replacement failed (" $ aClassName $ ")");
		return false;
	}

	log("HXExtMutator::ReplaceScriptedPawnWith(): Spawned ScriptedPawn Replacement (" $ aClassName $ ")");

	A.event = Other.event;
	A.tag = Other.tag;

	if (!A.isA('ScriptedPawn'))
		return true; // replaced but no ScriptedPawn now

	if (Other.isA('HumanMilitary'))
	{
		for (i = 0; i < 8; i++)
		{
			A.InitialInventory[i].Inventory = None;
			A.InitialInventory[i].Inventory = CheckInventoryReplacement(Other.InitialInventory[i].Inventory);
		}

		for(Inv=A.Inventory; Inv!=None; Inv=Inv.Inventory)
			Inv.Destroy();

		A.InitializeInventory();
		A.SwitchToBestWeapon();

		A.Alliance = Other.Alliance;
		A.InitializeAlliances();

	}

	// TODO: maybe copy some variables

	return true;
}

// ----------------------------------------------------------------------
// CheckInventoryReplacement()
// ----------------------------------------------------------------------
function class<Inventory> CheckInventoryReplacement(class<Inventory> AClass)
{
	return AClass;
}


// ----------------------------------------------------------------------
// UpdateDeusExCarcassWith()
// ----------------------------------------------------------------------
function UpdateDeusExCarcassWith(DeusExCarcass src, DeusExCarcass dst)
{
}


// ----------------------------------------------------------------------
// UpdateHackableDevicesWith()
// ----------------------------------------------------------------------
function UpdateHackableDevicesWith(HackableDevices src, HackableDevices dst)
{
	CopyHackableDevicesVars(src, dst);
	if (src.isA('Keypad') && dst.isA('KeyPad'))
		CopyKeypadVars(Keypad(src), Keypad(dst));
}


// ----------------------------------------------------------------------
// UpdateDeusExMoverWith()
// ----------------------------------------------------------------------
function UpdateDeusExMoverWith(DeusExMover src, DeusExMover dst)
{
	UpdateMoverWith(src, dst);
	CopyDeusExMoverVars(src, dst);
}


// ----------------------------------------------------------------------
// CopyDeusExMoverVars()
// ----------------------------------------------------------------------
function CopyDeusExMoverVars(DeusExMover src, DeusExMover dst)
{
	dst.bOneWay = src.bOneWay;
	dst.bLocked = src.bLocked;
	dst.bPickable = src.bPickable;
	dst.lockStrength = src.lockStrength;
	dst.initiallockStrength = src.initiallockStrength;
	dst.bInitialLocked = src.bInitialLocked;
	dst.bBreakable = src.bBreakable;
	dst.doorStrength = src.doorStrength;
	dst.KeyIDNeeded = src.KeyIDNeeded;
	dst.bHighlight = src.bHighlight;
	dst.bFrobbable = src.bFrobbable;
	dst.minDamageThreshold = src.minDamageThreshold;
	dst.bDestroyed = src.bDestroyed;
	dst.NumFragments = src.NumFragments;
	dst.FragmentScale = src.FragmentScale;
	dst.FragmentSpread = src.FragmentSpread;
	dst.FragmentClass = src.FragmentClass;
	dst.FragmentTexture = src.FragmentTexture;
	dst.bFragmentTranslucent = src.bFragmentTranslucent;
	dst.bFragmentUnlit = src.bFragmentUnlit;
	dst.ExplodeSound1 = src.ExplodeSound1;
	dst.ExplodeSound2 = src.ExplodeSound2;
	dst.bDrawExplosion = src.bDrawExplosion;
	dst.bIsDoor = src.bIsDoor;
	dst.TimeSinceReset = src.TimeSinceReset;
	dst.TimeToReset = src.TimeSinceReset;
}


// ----------------------------------------------------------------------
// CopyHackableDevicesVars()
// ----------------------------------------------------------------------
function CopyHackableDevicesVars(HackableDevices src, HackableDevices dst)
{
	dst.bHackable = src.bHackable;
	dst.hackStrength = src.hackStrength;
	dst.initialhackStrength = src.initialhackStrength;
	dst.UnTriggerEvent[0] = src.UnTriggerEvent[0];
	dst.UnTriggerEvent[1] = src.UnTriggerEvent[1];
	dst.UnTriggerEvent[2] = src.UnTriggerEvent[2];
	dst.UnTriggerEvent[3] = src.UnTriggerEvent[3];
	dst.TimeSinceReset = src.TimeSinceReset;
	dst.TimeToReset = src.TimeToReset;
}


// ----------------------------------------------------------------------
// CopyKeypadVars()
// ----------------------------------------------------------------------
function CopyKeypadVars(Keypad src, Keypad dst)
{
	dst.validCode = src.validCode;
	dst.bToggleLock = src.bToggleLock;
	dst.FailEvent = src.FailEvent;
}


// ----------------------------------------------------------------------
// defaultproperties
// ----------------------------------------------------------------------
defaultproperties
{
}
