//=============================================================================
// HXExtMutator.cpp
//=============================================================================

#include "HXExtensionPrivate.h"

IMPLEMENT_PACKAGE(HXExtension)

IMPLEMENT_CLASS(AHXExtMutator)

IMPLEMENT_FUNCTION(AHXExtMutator, 2300, execUpdateMoverWith);
IMPLEMENT_FUNCTION(AHXExtMutator, 2301, execFixPawnListLinks);

// CopyActorBrush()
void AHXExtMutator::execUpdateMoverWith(FFrame &Stack, RESULT_DECL)
{
	guard(AHXExtMutator::execUpdateMoverWith);
	
	P_GET_ACTOR(src);
	P_GET_ACTOR(dst);
	P_FINISH;

	dst->Brush = src->Brush;
	/*
	dst->Brush = new UModel();

	// UPolys*
	dst->Brush->Polys = new UPolys();
	dst->Brush->Polys->Element = TTransArray<FPoly>(src->Brush->Polys->Element);

	// TTransArray(s)
	dst->Brush->Nodes = TTransArray<FBspNode>(src->Brush->Nodes);
	dst->Brush->Verts = TTransArray<FVert>(src->Brush->Verts);
	dst->Brush->Vectors = TTransArray<FVector>(src->Brush->Vectors);
	dst->Brush->Points = TTransArray<FVector>(src->Brush->Points);
	dst->Brush->Surfs = TTransArray<FBspSurf>(src->Brush->Surfs);

	// TArray(s)
	dst->Brush->LightMap = TArray<FLightMapIndex>(src->Brush->LightMap);
	dst->Brush->LightBits = TArray<BYTE>(src->Brush->LightBits);
	dst->Brush->Bounds = TArray<FBox>(src->Brush->Bounds);
	dst->Brush->LeafHulls = TArray<INT>(src->Brush->LeafHulls);
	dst->Brush->Leaves = TArray<FLeaf>(src->Brush->Leaves);
	dst->Brush->Lights = TArray<AActor *>(src->Brush->Lights);
	*/

	CopyBrushVars((ABrush *)src, (ABrush *)dst);
	CopyMoverVars((AMover *)src, (AMover *)dst);

	src->bNoDelete = false;

	unguard;
}

// FixPawnListLinks()
void AHXExtMutator::execFixPawnListLinks(FFrame &Stack, RESULT_DECL)
{
	guard(AHXExtMutator::execFixPawnListLinks);

	P_GET_OBJECT(ALevelInfo, Level);
	P_GET_OBJECT(APawn, OldPawn);
	P_GET_OBJECT(APawn, NewPawn);
	P_GET_OBJECT_OPTX(APawn, OldPrevPawn, NULL);
	P_GET_OBJECT_OPTX(APawn, OldNextPawn, NULL);
	P_FINISH;

	NewPawn->nextPawn = OldNextPawn;

	if (OldPrevPawn != NULL)
		OldPrevPawn->nextPawn = NewPawn;
	else
		Level->PawnList = NewPawn;

	OldPawn->nextPawn = NULL;

	unguard;
}
