//=============================================================================
// HXExtMutatorUTIL->cpp: helper functions to copy variables
//=============================================================================

#include "HXExtensionPrivate.h"

// ----------------------------------------------------------------------
// CopyBrushVars()
// ----------------------------------------------------------------------
void CopyBrushVars(ABrush* src, ABrush* dst)
{
	dst->CopyPosRotScaleFrom(src);

	//dst->CsgOper = src->CsgOper;

	dst->TempScale = src->TempScale;
	dst->BrushColor = src->BrushColor;
	dst->PolyFlags = src->PolyFlags;
	dst->bColored = src->bColored;

	// Outdated.
	dst->UnusedLightMesh = src->UnusedLightMesh;
	dst->PostPivot = src->PostPivot;

	// Already copied by CopyPosRotScaleFrom()
	//src->MainScale = dst->MainScale;
	//src->PostScale = dst->PostScale;
}


// ----------------------------------------------------------------------
// CopyMoverVars()
// ----------------------------------------------------------------------

void CopyMoverVars(AMover* src, AMover* dst)
{
	int i;

	dst->MoverEncroachType = src->MoverEncroachType;
	dst->MoverGlideType = src->MoverGlideType;
	dst->BumpType = src->BumpType;

	// Keyframe numbers
	dst->KeyNum = src->KeyNum;
	dst->PrevKeyNum = src->PrevKeyNum;
	dst->NumKeys = src->NumKeys;
	//dst->WorldRaytraceKey = src->WorldRaytraceKey;
	//dst->BrushRaytraceKey = src->BrushRaytraceKey;

	// Movement parameters
	dst->MoveTime = src->MoveTime;
	dst->StayOpenTime = src->StayOpenTime;
	dst->OtherTime = src->OtherTime;
	dst->EncroachDamage = src->EncroachDamage;

	// Mover state
	dst->bTriggerOnceOnly = src->bTriggerOnceOnly;
	dst->bSlave = src->bSlave;
	dst->bUseTriggered = src->bUseTriggered;
	dst->bDamageTriggered = src->bDamageTriggered;
	dst->bDynamicLightMover = src->bDynamicLightMover;
	dst->PlayerBumpEvent = src->PlayerBumpEvent;
	dst->BumpEvent = src->BumpEvent;
	dst->SavedTrigger = src->SavedTrigger;
	dst->DamageThreshold = src->DamageThreshold;
	dst->numTriggerEvents = src->numTriggerEvents;
	dst->Leader = src->Leader;
	dst->Follower = src->Follower;
	dst->ReturnGroup = src->ReturnGroup;
	dst->DelayTime = src->DelayTime;

	// Audio
	dst->OpeningSound = src->OpeningSound;
	dst->OpenedSound = src->OpenedSound;
	dst->ClosingSound = src->ClosingSound;
	dst->ClosedSound = src->ClosedSound;
	dst->MoveAmbientSound = src->MoveAmbientSound;

	// Internal
	for (i = 0; i < 8; i++)
	{
		dst->KeyPos[i] = src->KeyPos[i];
		dst->KeyRot[i] = src->KeyRot[i];
	}

	dst->BasePos = src->BasePos;
	dst->OldPos = src->OldPos;
	dst->OldPrePivot = src->OldPrePivot;
	dst->SavedPos = src->SavedPos;
	dst->BaseRot = src->BaseRot;
	dst->OldRot = src->OldRot;
	dst->SavedRot = src->SavedRot;

	// AI related
	dst->myMarker = src->myMarker;
	dst->TriggerActor = src->TriggerActor;
	dst->TriggerActor2 = src->TriggerActor2;
	dst->WaitingPawn = src->WaitingPawn;
	dst->bOpening = src->bOpening;
	dst->bDelaying = src->bDelaying;
	dst->bClientPause = src->bClientPause;
	dst->bPlayerOnly = src->bPlayerOnly;
	dst->RecommendedTrigger = src->RecommendedTrigger;

	// for client side replication
	dst->SimOldPos = src->SimOldPos;
	dst->SimOldRotPitch = src->SimOldRotPitch;
	dst->SimOldRotYaw = src->SimOldRotYaw;
	dst->SimOldRotRoll = src->SimOldRotRoll;
	dst->SimInterpolate = src->SimInterpolate;
	dst->RealPosition = src->RealPosition;
	dst->RealRotation = src->RealRotation;
	dst->ClientUpdate = src->ClientUpdate;
}
