//=============================================================================
// HXCoopRootWindow
//=============================================================================
class HXCoopRootWindow extends DeusExRootWindow;

// ----------------------------------------------------------------------
// InitWindow()
// ----------------------------------------------------------------------

event InitWindow()
{
	Super(RootWindow).InitWindow();

	// Initialize variables
	winCount = 0;

	actorDisplay = ActorDisplayWindow(NewChild(Class'ActorDisplayWindow'));
	actorDisplay.SetWindowAlignments(HALIGN_Full, VALIGN_Full);

	hud = DeusExHUD(NewChild(Class'HXCoopHUD'));
	hud.UpdateSettings(DeusExPlayer(parentPawn));
	hud.SetWindowAlignments(HALIGN_Full, VALIGN_Full, 0, 0);

	scopeView = DeusExScopeView(NewChild(Class'DeusExScopeView', False));
	scopeView.SetWindowAlignments(HALIGN_Full, VALIGN_Full, 0, 0);

	SetDefaultCursor(Texture'DeusExCursor1', Texture'DeusExCursor1_Shadow');

	scopeView.Lower();

	ConditionalBindMultiplayerKeys();
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	DataVaultFunctions(0)=(Function="ShowInventoryWindow",winClass=Class'HXCoop.HXPersonaScreenInventory')
	DataVaultFunctions(1)=(Function="ShowHealthWindow",winClass=Class'HXCoop.HXPersonaScreenHealth')
	DataVaultFunctions(2)=(Function="ShowAugmentationsWindow",winClass=Class'HXCoop.HXPersonaScreenAugmentations')
	DataVaultFunctions(3)=(Function="ShowSkillsWindow",winClass=Class'HXCoop.HXPersonaScreenSkills')
	DataVaultFunctions(4)=(Function="ShowGoalsWindow",winClass=Class'HXCoop.HXPersonaScreenGoals')
	DataVaultFunctions(5)=(Function="ShowConversationsWindow",winClass=Class'HXCoop.HXPersonaScreenConversations')
	DataVaultFunctions(6)=(Function="ShowImagesWindow",winClass=Class'HXCoop.HXPersonaScreenImages')
	DataVaultFunctions(7)=(Function="ShowLogsWindow",winClass=Class'HXCoop.HXPersonaScreenLogs')
}
