//=============================================================================
// HXDataLinkEventDisposer
//=============================================================================
class HXDataLinkEventDisposer extends HXEventDisposer;


struct S_InfoLinkNames 
{
	var string BindName;
	var string DisplayName;
};

var HXDataLinkPlayer dataLinkPlayer;

var float blinkRate;

var int blinks;

// keep those horrible hacks... oh my... but can't change it anyway :(
var S_InfoLinkNames infoLinkNames[17];


// ----------------------------------------------------------------------
// DisposeSpeech()
// ----------------------------------------------------------------------

function DisposeSpeech(ConEventSpeech event)
{
	local DeusExLevelInfo info;
	local string portrait;
	local int nameIndex;
	local string displayName;

	lastActor = event.speaker;

	if (!event.bContinued)
	{
		// find display name
		displayName = "";
		for(nameIndex=0; nameIndex<arrayCount(infoLinkNames); nameIndex++)
		{
			if (infoLinkNames[nameIndex].BindName == event.speakerName)
			{
				displayName = infoLinkNames[nameIndex].DisplayName;
				break;
			}
		}

		// find portrait name
		if (event.speakerName == "PaulDenton")
		{
			portrait = "InfoPortraits.PaulDenton_1";
		}
		else if (event.speakerName == "BobPage")
		{
			info = dataLinkPlayer.human.GetLevelInfo();

			if ((info != None) && (info.MissionNumber == 15))
				portrait = "InfoPortraits.BobPageAug";
		}
		else
		{
			portrait = "InfoPortraits." $ Left(event.speakerName, 16);
		}

		// now start stuff
		dataLinkPlayer.human.ClientDataLinkWinReset(displayName, portrait, event.conSpeech.speech);
	}
	else
	{
		// just display the new text
		dataLinkPlayer.human.ClientDataLinkWinDisplayText(event.conSpeech.speech);
	}

	current = current.nextEvent;

	SetTimer(len(event.conSpeech.speech) * perCharDelay, false);
	GotoState('Waiting');
}


// ----------------------------------------------------------------------
// DisposeSetFlag()
// ----------------------------------------------------------------------

function DisposeSetFlag(ConEventSetFlag event)
{
	// dry runner will set flag
	current = current.nextEvent;
}


// ----------------------------------------------------------------------
// DisposeAddGoal()
// ----------------------------------------------------------------------

function DisposeAddGoal(ConEventAddGoal event)
{
	// dry runner will add goal
	current = current.nextEvent;
}


// ----------------------------------------------------------------------
// DisposeTrigger()
// ----------------------------------------------------------------------

function DisposeTrigger(ConEventTrigger event)
{
	// dry runner trigger
	current = current.nextEvent;
}


// ----------------------------------------------------------------------
// state Waiting
// ----------------------------------------------------------------------

state Waiting
{
	function Timer()
	{
		GotoState('Playing');
	}
}


// ----------------------------------------------------------------------
// state Starting
// ----------------------------------------------------------------------

state Starting
{
	function Timer()
	{
		if (blinks < 2)
		{
			dataLinkPlayer.human.ClientDataLinkWinShowDatalinkIcon((blinks++ % 2) == 0);
		}
		else
		{
			SetTimer(0.0, false);
			GotoState('Playing');
		}
	}

Begin:
	lastActor = none;
	blinks = 0;
	dataLinkPlayer.human.ClientDataLinkWinCreate();
	SetTimer(blinkRate, true);

}


// ----------------------------------------------------------------------
// state Ending
// ----------------------------------------------------------------------

state Ending
{
	function Timer()
	{
		if (blinks < 2)
		{
			dataLinkPlayer.human.ClientDataLinkWinShowWinName((blinks++ % 2) == 0);
		}
		else
		{
			SetTimer(0.0, false);
			dataLinkPlayer.human.ClientDataLinkWinDestroy();
			dataLinkPlayer.DisposeFinished();
		}
	}

Begin:
	blinks = 0;
	dataLinkPlayer.human.ClientDataLinkWinSetEndText();
	SetTimer(blinkRate, true);

}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	blinkRate=0.500000
	perCharDelay=0.030000
	infoLinkNames(0)=(BindName="AlexJacobson",displayName="Alex Jacobson")
	infoLinkNames(1)=(BindName="AnnaNavarre",displayName="Anna Navarre")
	infoLinkNames(2)=(BindName="BobPage",displayName="Bob Page")
	infoLinkNames(3)=(BindName="BobPageAug",displayName="Bob Page")
	infoLinkNames(4)=(BindName="Daedalus",displayName="Daedalus")
	infoLinkNames(5)=(BindName="GarySavage",displayName="Gary Savage")
	infoLinkNames(6)=(BindName="GuntherHermann",displayName="Gunther Hermann")
	infoLinkNames(7)=(BindName="Helios",displayName="Helios")
	infoLinkNames(8)=(BindName="Icarus",displayName="Icarus")
	infoLinkNames(9)=(BindName="JaimeReyes",displayName="Jaime Reyes")
	infoLinkNames(10)=(BindName="Jock",displayName="Jock")
	infoLinkNames(11)=(BindName="MorganEverett",displayName="Morgan Everett")
	infoLinkNames(12)=(BindName="PaulDenton",displayName="Paul Denton")
	infoLinkNames(13)=(BindName="SamCarter",displayName="Sam Carter")
	infoLinkNames(14)=(BindName="StantonDowd",displayName="Stanton Dowd")
	infoLinkNames(15)=(BindName="TracerTong",displayName="Tracer Tong")
	infoLinkNames(16)=(BindName="WaltonSimons",displayName="Walton Simons")
}
