//=============================================================================
// HXDataLinkEventDryRunner
//=============================================================================
class HXDataLinkEventDryRunner extends HXEventDisposer;


// ----------------------------------------------------------------------
// DisposeSpeech()
// ----------------------------------------------------------------------

function DisposeSpeech(ConEventSpeech event)
{
	local DeusExLevelInfo info;
	local string portrait;
	local int nameIndex;
	local string displayName;

	lastActor = event.speaker;
	current = current.nextEvent;

	SetTimer(len(event.conSpeech.speech) * perCharDelay, false);
	GotoState('Waiting');
}


// ----------------------------------------------------------------------
// DisposeEnd()
// ----------------------------------------------------------------------

function DisposeEnd()
{
	Super.DisposeEnd();
	SetPlayed();
	HXCoopGame(Level.Game).GameState.DryRunnerFinished();
}


// ----------------------------------------------------------------------
// state Playing
// ----------------------------------------------------------------------

state Playing
{
Begin:
	while (current != none)
		Dispose();
}


// ----------------------------------------------------------------------
// state Waiting
// ----------------------------------------------------------------------

state Waiting
{
	function Timer()
	{
		GotoState('Playing');
	}
}


// ----------------------------------------------------------------------
// state Starting
// ----------------------------------------------------------------------

state Starting
{
	function Timer()
	{
		SetTimer(0.0, false);
		GotoState('Playing');
	}

Begin:
	lastActor = none;
	SetTimer(2.0, true);
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	perCharDelay=0.030000
}
