//=============================================================================
// HXDeusExCarcassMutator
//=============================================================================
class HXDeusExCarcassMutator extends HXMutator;


// ----------------------------------------------------------------------
// CheckReplacement()
// ----------------------------------------------------------------------

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
	local DeusExCarcass OtherC;
	local HXGenericCarcass C;
	local Inventory inv;
	local int i, j;

	if (!Other.isA('DeusExCarcass') || Other.isA('HXGenericCarcass'))
		return true;

	C = spawn(class'HXGenericCarcass', Other.Owner, Other.tag, Other.Location, Other.Rotation);

	if (C == none)
	{
		Log("(EE) Spawning Carcass Replacment failed");
		return false;
	}

	OtherC = DeusExCarcass(Other);

	CopyDeusExCarcassVars(OtherC, C);
	CopyNonConfigVars(OtherC, C);

	// Add initial inventory items
	for (i = 0; i < 8; i++)
	{
		if ((C.InitialInventory[i].inventory != None) && (C.InitialInventory[i].count > 0))
		{
			for (j = 0; j < C.InitialInventory[i].count; j++)
			{
				inv = spawn(C.InitialInventory[i].inventory, C);
				if (inv != None)
				{
					inv.bHidden = True;
					inv.SetPhysics(PHYS_None);
					C.AddInventory(inv);
				}
			}
		}
	}

	return false;
}


// ----------------------------------------------------------------------
// CopyNonConfigVars()
// ----------------------------------------------------------------------

function CopyNonConfigVars(DeusExCarcass OtherC, DeusExCarcass C)
{
	// Carcass part
	C.bPlayerCarcass	= OtherC.bPlayerCarcass;

	// DeusExCarcass part
	C.KillerBindName	= OtherC.KillerBindName;
	C.KillerAlliance	= OtherC.KillerAlliance;
	C.bGenerateFlies	= OtherC.bGenerateFlies;
	C.Alliance				= OtherC.Alliance;
	C.CarcassName			= OtherC.CarcassName;
	C.MaxDamage				= OtherC.MaxDamage;
	C.bNotDead				= OtherC.bNotDead;
	C.itemName				= OtherC.itemName;
	C.bAnimalCarcass	= OtherC.bAnimalCarcass;
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	bCopyActorMovement=False
	bCopyActorMovementConst=False
	bCopyActorLighting=True
	bCopyActorLightColor=True
	bCopyActorDisplay=True
	bCopyActorNetwork=False
	bCopyActorFilter=False
	bCopyActorSound=True
}
