//=============================================================================
// HXEventDisposer
//=============================================================================
class HXEventDisposer extends Actor
	abstract;

var ConEvent current;
var Conversation con;

var Actor lastActor;
var string invokerName;

var float perCharDelay;


// ----------------------------------------------------------------------
// DisposeSpeech()
// ----------------------------------------------------------------------

function DisposeSpeech(ConEventSpeech event)
{
	current = current.nextEvent;
}


// ----------------------------------------------------------------------
// DisposeChoice()
// ----------------------------------------------------------------------

function DisposeChoice(ConEventChoice event)
{
	// this makes only sense in real conversations
	current = current.nextEvent;
}


// ----------------------------------------------------------------------
// DisposeSetFlag()
// ----------------------------------------------------------------------

function DisposeSetFlag(ConEventSetFlag event)
{
	local ConFlagRef ref;

	ref = event.flagRef;

	while(ref != none)
	{
		HXCoopGame(Level.Game).GameState.flags.SetBool(ref.flagName, ref.value);
		HXCoopGame(Level.Game).GameState.flags.SetExpiration(ref.flagName, FLAG_Bool, ref.expiration);

		ref = ref.nextFlagRef;
	}

	current = current.nextEvent;
}


// ----------------------------------------------------------------------
// DisposeCheckFlag()
// ----------------------------------------------------------------------

function DisposeCheckFlag(ConEventCheckFlag event)
{
	local ConFlagRef ref;

	ref = event.flagRef;

	while(ref != none)
	{
		if (HXCoopGame(Level.Game).GameState.flags.GetBool(ref.flagName) != ref.value)
		{
			current = current.nextEvent;
			return;
		}
		ref = ref.nextFlagRef;
	}

	current = con.GetEventFromLabel(event.setLabel);
}


// ----------------------------------------------------------------------
// DisposeCheckObject()
// ----------------------------------------------------------------------

function DisposeCheckObject(ConEventCheckObject event)
{
	current = current.nextEvent;

	Log("(WW) ET_CheckObject: not implemented");
}


// ----------------------------------------------------------------------
// DisposeTransferObject()
// ----------------------------------------------------------------------

function DisposeTransferObject(ConEventTransferObject event)
{
	current = current.nextEvent;

	Log("(WW) ET_TransferObject: not implemented");
}


// ----------------------------------------------------------------------
// DisposeMoveCamera()
// ----------------------------------------------------------------------

function DisposeMoveCamera(ConEventMoveCamera event)
{
	// this is only used in real conversations
	current = current.nextEvent;
}


// ----------------------------------------------------------------------
// DisposeAnimation()
// ----------------------------------------------------------------------

function DisposeAnimation(ConEventAnimation event)
{
	// this is only used in real conversations
	current = current.nextEvent;
}


// ----------------------------------------------------------------------
// DisposeJump()
// ----------------------------------------------------------------------

function DisposeJump(ConEventJump event)
{
	if (event.jumpLabel == "")
	{
		current = current.nextEvent;
		return;
	}

	if (event.jumpCon != none)
	{
		// uhm yeah... fuck ^_^
		Log("(EE) Jump to Conversation not supported");
		Assert(1 == 0);
	}
	else
	{
		current = con.GetEventFromLabel(event.jumpLabel);
	}
}


// ----------------------------------------------------------------------
// DisposeRandom()
// ----------------------------------------------------------------------

function DisposeRandom(ConEventRandomLabel event)
{
	current = con.GetEventFromLabel(event.GetRandomLabel());
}


// ----------------------------------------------------------------------
// DisposeTrigger()
// ----------------------------------------------------------------------

function DisposeTrigger(ConEventTrigger event)
{
	local Actor TriggerHappy;

	// Loop through all the actors, firing a trigger for each
	foreach AllActors(class'Actor', TriggerHappy, event.triggerTag)
	{
		TriggerHappy.Trigger(lastActor, Pawn(lastActor));

		if (TriggerHappy.isA('DeusExMover'))
		{
			if (DeusExMover(TriggerHappy).bLocked)
			{
				DeusExMover(TriggerHappy).bLocked = false;
				Log("(NN) Setting bLocked to false on a triggered DeusExMover (Con)");
			}
		}
	}

	current = current.nextEvent;
}


// ----------------------------------------------------------------------
// DisposeAddGoal()
// ----------------------------------------------------------------------

function DisposeAddGoal(ConEventAddGoal event)
{
	// simply call AddGoal(), it will check if goal already exists,
	// so don't do it twice
	
	if (!event.bGoalCompleted)
		HXCoopGame(Level.Game).GameState.AddGoal(event.goalName, event.bPrimaryGoal, event.goalText, invokerName);
	else
		HXCoopGame(Level.Game).GameState.GoalCompleted(event.goalName, invokerName);

	current = current.nextEvent;
}


// ----------------------------------------------------------------------
// DisposeAddNote()
// ----------------------------------------------------------------------

function DisposeAddNote(ConEventAddNote event)
{
	current = current.nextEvent;

	Log("(WW) ET_AddNote: not implemented");
}


// ----------------------------------------------------------------------
// DisposeAddSkillPoints()
// ----------------------------------------------------------------------

function DisposeAddSkillPoints(ConEventAddSkillPoints event)
{
	current = current.nextEvent;

	Log("(WW) ET_AddSkillPoints: not implemented");
}


// ----------------------------------------------------------------------
// DisposeAddCredits()
// ----------------------------------------------------------------------

function DisposeAddCredits(ConEventAddCredits event)
{
	current = current.nextEvent;

	Log("(WW) ET_AddCredits: not implemented");
}


// ----------------------------------------------------------------------
// DisposeCheckPersona()
// ----------------------------------------------------------------------

function DisposeCheckPersona(ConEventCheckPersona event)
{
	current = current.nextEvent;

	Log("(WW) ET_CheckPersona: not implemented");
}


// ----------------------------------------------------------------------
// DisposeEnd()
// ----------------------------------------------------------------------

function DisposeEnd()
{
	current = none;

	GotoState('Ending');
}


// ----------------------------------------------------------------------
// SetPlayed()
// ----------------------------------------------------------------------

function SetPlayed()
{
	local name flagName;

	flagName = HXCoopGame(Level.Game).GameState.flags.StringToName(con.conName $ "_Played");

	if (!HXCoopGame(Level.Game).GameState.flags.GetBool(flagName))
		HXCoopGame(Level.Game).GameState.flags.SetBool(flagName, True);

	con.lastPlayedTime = Level.TimeSeconds;
}



// ----------------------------------------------------------------------
// Dispose()
// ----------------------------------------------------------------------

function Dispose()
{

	switch (current.EventType)
	{
		case ET_Speech:
			DisposeSpeech(ConEventSpeech(current));
			break;
		case ET_Choice:
			DisposeChoice(ConEventChoice(current));
			break;
		case ET_SetFlag:
			DisposeSetFlag(ConEventSetFlag(current));
			break;
		case ET_CheckFlag:
			DisposeCheckFlag(ConEventCheckFlag(current));
			break;
		case ET_CheckObject:
			DisposeCheckObject(ConEventCheckObject(current));
			break;
		case ET_TransferObject:
			DisposeTransferObject(ConEventTransferObject(current));
			break;
		case ET_MoveCamera:
			DisposeMoveCamera(ConEventMoveCamera(current));
			break;
		case ET_Animation:
			DisposeAnimation(ConEventAnimation(current));
			break;
		case ET_Jump:
			DisposeJump(ConEventJump(current));
			break;
		case ET_Random:
			DisposeRandom(ConEventRandomLabel(current));
			break;
		case ET_Trigger:
			DisposeTrigger(ConEventTrigger(current));
			break;
		case ET_AddGoal:
			DisposeAddGoal(ConEventAddGoal(current));
			break;
		case ET_AddNote:
			DisposeAddNote(ConEventAddNote(current));
			break;
		case ET_AddSkillPoints:
			DisposeAddSkillPoints(ConEventAddSkillPoints(current));
			break;
		case ET_AddCredits:
			DisposeAddCredits(ConEventAddCredits(current));
			break;
		case ET_CheckPersona:
			DisposeCheckPersona(ConEventCheckPersona(current));
			break;
		case ET_Trade:
		case ET_Comment:
			current = current.nextEvent;
			break;
		case ET_End:
			DisposeEnd();			
			break;

		default:
			Log("(WW) This can should never happen, but...");
			current = current.nextEvent;
			break;

	}

}



// ----------------------------------------------------------------------
// state Playing
// ----------------------------------------------------------------------

state Playing
{
Begin:
	while (current != none)
		Dispose();
}


// ----------------------------------------------------------------------
// state Ending
// ----------------------------------------------------------------------

state Ending
{

}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	bHidden=true
}
