//=============================================================================
// HXHUDKeypadButton
//=============================================================================
class HXHUDKeypadButton extends HUDKeypadButton;


// ----------------------------------------------------------------------
// DrawWindow()
// ----------------------------------------------------------------------

event DrawWindow(GC gc)
{		
	// Draw the button graphic
	gc.SetTileColor(colBackground);

	if (bBackgroundTranslucent)
		gc.SetStyle(DSTY_Translucent);
	else
		gc.SetStyle(DSTY_Masked);
	
	if (bButtonPressed)
		gc.DrawTexture(0, 0, width, height, 0, 0, keypadButtonTextures[1]);
	else
		gc.DrawTexture(0, 0, width, height, 0, 0, keypadButtonTextures[0]);

	// Display darker if the button's insensitive
	if (bIsSensitive)
		gc.SetTextColor(colSensitive);
	else
		gc.SetTextColor(colInsensitive);

	// If the button is currently being depressed, then draw the 
	// graphic down and to the right one.
	gc.SetFont(Font'FontMenuExtraLarge');
	gc.SetAlignments(HALIGN_Center, VALIGN_Center);
	gc.EnableTranslucentText(True);

	if (bButtonPressed)
		gc.DrawText(1, 3, width, height, IndexToString(num));
	else
		gc.DrawText(0, 2, width, height, IndexToString(num));
}


// ----------------------------------------------------------------------
// IndexToString()
//
// Convert the numbered button to a character
// ----------------------------------------------------------------------

function string IndexToString(int num)
{
	local string str;

	// buttons 0-8 are ok as is (text 1-9)
	// button 9 is *
	// button 10 is 0
	// button 11 is #
	switch (num)
	{
		case 9:		str = "*"; break;
		case 10:	str = "0"; break;
		case 11:	str = "#"; break;
		default:	str = String(num+1); break;
	}

	return str;
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
}
