//=============================================================================
// HXInventoryDeleteTrigger
//=============================================================================
class HXInventoryDeleteTrigger extends Trigger;


// ----------------------------------------------------------------------
// Touch()
// ----------------------------------------------------------------------

function Touch(Actor Other)
{
	local HXHuman human;

	if (!Other.isA('HXHuman'))
		return;

	RemoveAllInventory(HXHuman(Other));

}


// ----------------------------------------------------------------------
// RemoveAllInventory()
// copied from Mission00.uc
// ----------------------------------------------------------------------

function RemoveAllInventory(HXHuman player)
{
	local Inventory item, nextItem, lastItem;

	if (Player.Inventory != None)
	{
		item = Player.Inventory;
		nextItem = item.Inventory;
		lastItem = item;

		do
		{
			if ((item != None) && item.bDisplayableInv || item.IsA('Ammo'))
			{
				// make sure everything is turned off
				if (item.IsA('DeusExWeapon'))
				{
					DeusExWeapon(item).ScopeOff();
					DeusExWeapon(item).LaserOff();
				}
				if (item.IsA('DeusExPickup'))
				{
					if (DeusExPickup(item).bActive)
						DeusExPickup(item).Activate();
				}

   			if (item.IsA('ChargedPickup'))
					Player.RemoveChargedDisplay(ChargedPickup(item));

				Player.DeleteInventory(item);
				item.Destroy();
				item = Player.Inventory;
			}
			else
				item = nextItem;

			if (item != None)
				nextItem = item.Inventory;
		}
		until ((item == None) || (item == lastItem));
	}
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	bTriggerOnceOnly=false
}
