//=============================================================================
// HXKeypad
//=============================================================================
class HXKeypad extends HXHackableDevices;

var() string validCode;
var() sound successSound;
var() sound failureSound;
var() name FailEvent;
var() bool bToggleLock;		// if True, toggle the lock state instead of triggering

var HXHUDKeypadWindow keypadwindow;

var bool bInUse;

// ----------------------------------------------------------------------
// Network Replication
// ----------------------------------------------------------------------

replication
{
   //server to client variables
   reliable if ( Role == ROLE_Authority )
      bToggleLock, FailEvent, validCode;

   reliable if ( Role < ROLE_Authority )
      bInUse;
}


// ----------------------------------------------------------------------
// HackAction()
// ----------------------------------------------------------------------


function HackAction(Actor Hacker, bool bHacked)
{
	local HXHuman human;

	// HX_NOTE: this makes no sence in MP
	//if (keypadwindow != None)
		//return;
	
	human = HXHuman(Hacker);

	if (human != None)
	{
		// if keypad was hacked, act directly
		if (bHacked)
		{
			if (Event != '')
			{
				// Toggle the locked/unlocked state of the DeusExMover
				if (bToggleLock)
					ToggleLocks(human);
				else
					RunEvents(human, true);
			}

			// UnTrigger event (if used)
			RunUntriggers(human);
		}

		human.currentKeypad = self;
		human.ClientKeypadWinCreate(bHacked, validCode);
	}
}


// ----------------------------------------------------------------------
// ActivateKeypadWindow
// DEUS_EX AMSD Bounce back call from player so function rep works right.
// ----------------------------------------------------------------------

simulated function ActivateKeypadWindow(HXHuman Hacker, bool bHacked)
{
/*
	local DeusExRootWindow root;

   root = HXCoopRootWindow(Hacker.rootWindow);
   if (root != None)
   {
      keypadwindow = HXHUDKeypadWindow(root.InvokeUIScreen(Class'HXHUDKeypadWindow', True));
      root.MaskBackground(True);
      
      // copy the tag data to the actual class
      if (keypadwindow != None)
      {
         keypadwindow.hxkeypadOwner = Self;
         keypadwindow.player = Hacker;
         keypadwindow.bInstantSuccess = bHacked;
         keypadwindow.InitData();
      }
   }
*/
}


// ----------------------------------------------------------------------
// RunUntriggers()
// DEUS_EX AMSD Bounce back call from player so function rep works right.
// ----------------------------------------------------------------------

function RunUntriggers(HXHuman Player)
{
   local Actor A;
   local int i;

   for (i=0; i<ArrayCount(UnTriggerEvent); i++)
   {
      if (UnTriggerEvent[i] != '')
      {
         foreach AllActors(class 'Actor', A, UnTriggerEvent[i])
         {
            A.UnTrigger(Self, Player);
         }
      }
   }
}


// ----------------------------------------------------------------------
// RunEvents()
// ----------------------------------------------------------------------

function RunEvents(HXHuman Player, bool bSuccess)
{
   local Actor A;

   if ((bSuccess) && (Event != ''))
   {
      foreach AllActors(class 'Actor', A, Event)
         A.Trigger(Self, Player);
   }
   else if ((!bSuccess) && (FailEvent != ''))
   {
      foreach AllActors(class 'Actor', A, FailEvent)
         A.Trigger(Self, Player);
   }
}


// ----------------------------------------------------------------------
// ToggleLocks()
// ----------------------------------------------------------------------

function ToggleLocks(HXHuman Player)
{
   local Actor A;
   if (bToggleLock)
   {
      foreach AllActors(class 'Actor', A, Event)
         if (A.IsA('DeusExMover'))
            DeusExMover(A).bLocked = !DeusExMover(A).bLocked;
   }
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	validCode="1234"
	successSound=Sound'DeusExSounds.Generic.Beep2'
	failureSound=Sound'DeusExSounds.Generic.Buzz1'
	bToggleLock=True
	ItemName="Security Keypad"
	Mass=10.000000
	Buoyancy=5.000000
	bInUse=False
}
