//=============================================================================
// HXMedicalBot
//=============================================================================
class HXMedicalBot extends HXRobot;

var int healAmount;
var int healRefreshTime;
var float lastHealTime;


// ----------------------------------------------------------------------
// network replication
// ----------------------------------------------------------------------

replication
{
	// MBCODE: Replicate the last time healed to the server
	//reliable if (Role < ROLE_Authority)
	// HX_NOTE: you probably also replicate the last time 
	//					jacked off to your girlfriend...
	reliable if (Role == ROLE_Authority)
		lastHealTime; //healRefreshTime;
	// HX_NOTE: ...and that she is your girlfriend...
}


// ----------------------------------------------------------------------
// PostBeginPlay()
// ----------------------------------------------------------------------

function PostBeginPlay()
{
	Super.PostBeginPlay();

	// HX_NOTE: i don't get the point... (again)
	if (IsImmobile())
		bAlwaysRelevant = true;

	lastHealTime = -healRefreshTime;
}


// ----------------------------------------------------------------------
// StandStill()
// ----------------------------------------------------------------------

function StandStill()
{
	GotoState('Idle', 'Idle');
	Acceleration = Vect(0, 0, 0);
}


// ----------------------------------------------------------------------
// Frob()
//
// Invoke the Augmentation Upgrade 
// ----------------------------------------------------------------------

function Frob(Actor Frobber, Inventory frobWith)
{
	local DeusExPlayer player;
	local DeusExRootWindow root;
	local HUDMedBotAddAugsScreen winAug;
	local HUDMedBotHealthScreen  winHealth;
	local AugmentationCannister augCan;

	Super.Frob(Frobber, frobWith);

	player = DeusExPlayer(Frobber);

	if (player == None)
		return;

	// HX_NOTE: GotoState('Lerning', 'Indention');
	root = DeusExRootWindow(player.rootWindow);
	if (root != None)
	{
		// First check to see if the player has any augmentation cannisters.
		// If so, then we'll pull up the Add Augmentations screen.  
		// Otherwise pull up the Health screen first.

		augCan = AugmentationCannister(player.FindInventoryType(Class'AugmentationCannister'));

		if (augCan != None)
		{
			winAug = HUDMedBotAddAugsScreen(root.InvokeUIScreen(Class'HUDMedBotAddAugsScreen', True));
			//winAug.SetMedicalBot(Self, True);
		}
		else
		{
			winHealth = HUDMedBotHealthScreen(root.InvokeUIScreen(Class'HUDMedBotHealthScreen', True));
			//winHealth.SetMedicalBot(Self, True);
		}
		root.MaskBackground(True);
	}

}


// ----------------------------------------------------------------------
// HealPlayer()
// ----------------------------------------------------------------------

function int HealPlayer(DeusExPlayer player)
{
	local int healedPoints;

	// HX_NOTE: nag
	if (player != None)
	{
		healedPoints = player.HealPlayer(healAmount);
		lastHealTime = Level.TimeSeconds;
	}
	return healedPoints;
}

// ----------------------------------------------------------------------
// CanHeal()
// 
// Returns whether or not the bot can heal the player
// ----------------------------------------------------------------------

function bool CanHeal()
{	
	return (Level.TimeSeconds - lastHealTime > healRefreshTime);
}

// ----------------------------------------------------------------------
// GetRefreshTimeRemaining()
// ----------------------------------------------------------------------

function Float GetRefreshTimeRemaining()
{
	return healRefreshTime - (Level.TimeSeconds - lastHealTime);
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	healAmount=300
	healRefreshTime=60
	WalkingSpeed=0.200000
	GroundSpeed=200.000000
	WaterSpeed=50.000000
	AirSpeed=144.000000
	AccelRate=500.000000
	UnderWaterTime=20.000000
	AttitudeToPlayer=ATTITUDE_Ignore
	DrawType=DT_Mesh
	Mesh=LodMesh'DeusExCharacters.MedicalBot'
	SoundRadius=16
	SoundVolume=128
	AmbientSound=Sound'DeusExSounds.Robot.MedicalBotMove'
	CollisionRadius=25.000000
	CollisionHeight=36.310001
	Buoyancy=97.000000
	BindName="MedicalBot"
	FamiliarName="Medical Bot"
	UnfamiliarName="Medical Bot"
}

// HX_NOTE: must stop comments...
