//=============================================================================
// HXMenuMain - changed main menu
//=============================================================================

class HXMenuMain expands MenuUIMenuWindow;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

event InitWindow()
{
	Super.InitWindow();

	UpdateButtonStatus();
	ShowVersionInfo();
}

// ----------------------------------------------------------------------
// UpdateButtonStatus()
// ----------------------------------------------------------------------

function UpdateButtonStatus()
{
	local DeusExLevelInfo info;

	info = player.GetLevelInfo();

	if (player.Level.Netmode == NM_Standalone) {
		winButtons[2].SetSensitivity(False);
	}
	
}

// ----------------------------------------------------------------------
// ShowVersionInfo()
// ----------------------------------------------------------------------

function ShowVersionInfo()
{
	local TextWindow version;

	version = TextWindow(NewChild(Class'TextWindow'));
	version.SetTextMargins(0, 0);
	version.SetWindowAlignments(HALIGN_Right, VALIGN_Bottom);
	version.SetTextColorRGB(255, 255, 255);
	version.SetTextAlignments(HALIGN_Right, VALIGN_Bottom);
	version.SetText(player.GetDeusExVersion());
}

function ProcessCustomMenuButton(string key)
{
	switch(key)
	{
		case "DISCONNECT":
			Player.DisconnectPlayer();
			break;
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	ButtonNames(0)="Lan Game"
	ButtonNames(1)="Internet Game"
	ButtonNames(2)="Disconnect"
	ButtonNames(3)="Settings"
	ButtonNames(4)="Player Setup"
	ButtonNames(5)="Continue"
	ButtonNames(6)="Exit"
	buttonXPos=7
	buttonWidth=282
	buttonDefaults(0)=(Y=13,Action=MA_MenuScreen,Invoke=Class'HXCoop.HXMenuScreenJoinLan')
	buttonDefaults(1)=(Y=49,Action=MA_MenuScreen,Invoke=Class'HXCoop.HXMenuScreenJoinNet')
	buttonDefaults(2)=(Y=121,Action=MA_Custom,Key="DISCONNECT")
	buttonDefaults(3)=(Y=157,Invoke=Class'DeusEx.MenuSettings')
	buttonDefaults(4)=(Y=85,Action=MA_MenuScreen,Invoke=Class'DeusEx.MenuScreenPlayerSetup')
	buttonDefaults(5)=(Y=193,Action=MA_Previous)
	buttonDefaults(6)=(Y=266,Action=MA_Quit)
	Title="HX Coop"
	ClientWidth=294
	ClientHeight=308
	verticalOffset=2
	clientTextures(0)=Texture'DeusExUI.UserInterface.MenuOptionsBackground_1'
	clientTextures(1)=Texture'DeusExUI.UserInterface.MenuOptionsBackground_2'
	clientTextures(2)=Texture'DeusExUI.UserInterface.MenuOptionsBackground_3'
	clientTextures(3)=Texture'DeusExUI.UserInterface.MenuOptionsBackground_4'
	textureCols=2
}
