//=============================================================================
// HXMissionScriptMutator
//=============================================================================
class HXMissionScriptMutator extends HXMutator;

struct MissionScriptReplacement
{
	var class<MissionScript> Old;
	var class<MissionScript> New;
};

var MissionScriptReplacement Replacements[16];


// ----------------------------------------------------------------------
// CheckReplacement()
// ----------------------------------------------------------------------

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
	local DeusExLevelInfo Info;
	local int i;

	if (!Other.isA('DeusExLevelInfo'))
		return true;

	Info = DeusExLevelInfo(Other);

	for (i = 0; i < ArrayCount(Replacements); i++)
	{
		if (Info.Script != none && Info.Script == Replacements[i].Old)
		{
			Info.Script = Replacements[i].New;
			Log("(NN) Changed MissionScript '" $ Replacements[i].Old $ "' to '" $ Replacements[i].New $ "'");
			return true;
		}
	}
	Log("(WW) No Replacement MissionScript found");

	return true;
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	Replacements(0)=(Old=Class'DeusEx.Mission00',New=Class'HXCoop.HXMission00')
	Replacements(1)=(Old=Class'DeusEx.Mission01',New=Class'HXCoop.HXMission01')
	Replacements(2)=(Old=Class'DeusEx.Mission02',New=Class'HXCoop.HXMission02')
	Replacements(3)=(Old=Class'DeusEx.Mission03',New=Class'HXCoop.HXMission03')
	Replacements(4)=(Old=Class'DeusEx.Mission04',New=Class'HXCoop.HXMission04')
	Replacements(5)=(Old=Class'DeusEx.Mission05',New=Class'HXCoop.HXMission05')
	Replacements(6)=(Old=Class'DeusEx.Mission06',New=Class'HXCoop.HXMission06')
	Replacements(7)=(Old=Class'DeusEx.Mission08',New=Class'HXCoop.HXMission08')
	Replacements(8)=(Old=Class'DeusEx.Mission09',New=Class'HXCoop.HXMission09')
	Replacements(9)=(Old=Class'DeusEx.Mission10',New=Class'HXCoop.HXMission10')
	Replacements(10)=(Old=Class'DeusEx.Mission11',New=Class'HXCoop.HXMission11')
	Replacements(11)=(Old=Class'DeusEx.Mission12',New=Class'HXCoop.HXMission12')
	Replacements(12)=(Old=Class'DeusEx.Mission14',New=Class'HXCoop.HXMission14')
	Replacements(13)=(Old=Class'DeusEx.Mission15',New=Class'HXCoop.HXMission15')
	Replacements(14)=(Old=Class'DeusEx.MissionIntro',New=Class'HXCoop.HXMissionIntro')
	Replacements(15)=(Old=Class'DeusEx.MissionEndgame',New=Class'HXCoop.HXMissionEndgame')
}
