//=============================================================================
// HXWaltonSimons
//=============================================================================
class HXWaltonSimons extends HXHumanMilitary;

//
// Damage type table for Walton Simons:
//
// Shot			- 100%
// Sabot		- 100%
// Exploded		- 100%
// TearGas		- 10%
// PoisonGas	- 10%
// Poison		- 10%
// PoisonEffect	- 10%
// HalonGas		- 10%
// Radiation	- 10%
// Shocked		- 10%
// Stunned		- 0%
// KnockedOut   - 0%
// Flamed		- 0%
// Burned		- 0%
// NanoVirus	- 0%
// EMP			- 0%
//


// ----------------------------------------------------------------------
// ShieldDamage()
// ----------------------------------------------------------------------

function float ShieldDamage(name damageType)
{
	// handle special damage types
	if ((damageType == 'Flamed') || (damageType == 'Burned') || (damageType == 'Stunned') ||
	    (damageType == 'KnockedOut'))
		return 0.0;
	else if ((damageType == 'TearGas') || (damageType == 'PoisonGas') || (damageType == 'HalonGas') ||
			(damageType == 'Radiation') || (damageType == 'Shocked') || (damageType == 'Poison') ||
	        (damageType == 'PoisonEffect'))
		return 0.1;
	else
		return Super.ShieldDamage(damageType);
}


// ----------------------------------------------------------------------
// GotoDisabledState()
// ----------------------------------------------------------------------

function GotoDisabledState(name damageType, EHitLocation hitPos)
{
	if (!bCollideActors && !bBlockActors && !bBlockPlayers)
		return;
	if (CanShowPain())
		TakeHit(hitPos);
	else
		GotoNextState();
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	CarcassType=Class'DeusEx.WaltonSimonsCarcass'
	WalkingSpeed=0.333333
	bImportant=True
	bInvincible=True
	CloseCombatMult=0.500000
	BaseAssHeight=-23.000000
	BurnPeriod=0.000000
	bHasCloak=True
	CloakThreshold=150
	walkAnimMult=1.400000
	GroundSpeed=240.000000
	Health=600
	HealthHead=900
	HealthTorso=600
	HealthLegLeft=600
	HealthLegRight=600
	HealthArmLeft=600
	HealthArmRight=600
	Mesh=LodMesh'DeusExCharacters.GM_Trench'
	MultiSkins(0)=Texture'DeusExCharacters.Skins.WaltonSimonsTex0'
	MultiSkins(1)=Texture'DeusExCharacters.Skins.WaltonSimonsTex2'
	MultiSkins(2)=Texture'DeusExCharacters.Skins.PantsTex5'
	MultiSkins(3)=Texture'DeusExCharacters.Skins.WaltonSimonsTex0'
	MultiSkins(4)=Texture'DeusExCharacters.Skins.WaltonSimonsTex1'
	MultiSkins(5)=Texture'DeusExCharacters.Skins.WaltonSimonsTex2'
	MultiSkins(6)=Texture'DeusExItems.Skins.GrayMaskTex'
	MultiSkins(7)=Texture'DeusExItems.Skins.BlackMaskTex'
	CollisionRadius=20.000000
	CollisionHeight=47.500000
	BindName="WaltonSimons"
	FamiliarName="Walton Simons"
	UnfamiliarName="Walton Simons"
}
