//=============================================================================
// HXWeaponLAM
//=============================================================================
class HXWeaponLAM extends HXCoopWeapon;

var localized String shortName;

// ----------------------------------------------------------------------
// PostBeginPlay()
// ----------------------------------------------------------------------

function PostBeginPlay()
{
   Super.PostBeginPlay();
   bWeaponStay=False;
}

// ----------------------------------------------------------------------
// Fire()
// ----------------------------------------------------------------------

function Fire(float Value)
{
	// if facing a wall, affix the LAM to the wall
	if (Pawn(Owner) != None)
	{
		if (bNearWall)
		{
			bReadyToFire = False;
			GotoState('NormalFire');
			bPointing = True;
			PlayAnim('Place',, 0.1);
			return;
		}
	}

	// otherwise, throw as usual
	Super.Fire(Value);
}

// ----------------------------------------------------------------------
// Fire()
// ----------------------------------------------------------------------

function BecomePickup()
{
	// Become a pickup
	// Weapons that carry their ammo with them don't vanish when dropped
	Super.BecomePickup();
	if (Level.NetMode != NM_Standalone)
		if (bTossedOut)
		Lifespan = 0.0;
}

// ----------------------------------------------------------------------
// TestMPBeltSpot()
// ----------------------------------------------------------------------

simulated function bool TestMPBeltSpot(int BeltSpot)
{
	// Returns true if the suggested belt location is ok for the object in mp.
	return (BeltSpot == 6);
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	ShortName="LAM"
	LowAmmoWaterMark=2
	GoverningSkill=Class'DeusEx.SkillDemolition'
	EnviroEffective=ENVEFF_AirWater
	Concealability=CONC_All
	ShotTime=0.300000
	reloadTime=0.100000
	HitDamage=50
	maxRange=4800
	AccurateRange=2400
	BaseAccuracy=1.000000
	bHasMuzzleFlash=False
	bHandToHand=True
	bUseAsDrawnWeapon=False
	AITimeLimit=3.500000
	AIFireDelay=5.000000
	bNeedToSetMPPickupAmmo=False
	AmmoName=Class'HXCoop.HXAmmoLAM'
	ReloadCount=1
	PickupAmmoCount=1
	FireOffset=(Y=10.000000,Z=20.000000)
	ProjectileClass=Class'DeusEx.LAM'
	shakemag=50.000000
	SelectSound=Sound'DeusExSounds.Weapons.LAMSelect'
	InventoryGroup=20
	ItemName="Lightweight Attack Munitions (LAM)"
	PlayerViewOffset=(X=24.000000,Y=-15.000000,Z=-17.000000)
	PlayerViewMesh=LodMesh'DeusExItems.LAM'
	PickupViewMesh=LodMesh'DeusExItems.LAMPickup'
	ThirdPersonMesh=LodMesh'DeusExItems.LAM3rd'
	Icon=Texture'DeusExUI.Icons.BeltIconLAM'
	largeIcon=Texture'DeusExUI.Icons.LargeIconLAM'
	largeIconWidth=35
	largeIconHeight=45
	Description="A multi-functional explosive with electronic priming system that can either be thrown or attached to any surface with its polyhesive backing and used as a proximity mine.|n|n<UNATCO OPS FILE NOTE SC093-BLUE> Disarming a proximity device should only be attempted with the proper demolitions training. Trust me on this. -- Sam Carter <END NOTE>"
	beltDescription="LAM"
	Mesh=LodMesh'DeusExItems.LAMPickup'
	CollisionRadius=3.800000
	CollisionHeight=3.500000
	Mass=5.000000
	Buoyancy=2.000000
}
