//=============================================================================
// TouchHuman
//=============================================================================
class TouchHuman extends Human;

#exec TEXTURE IMPORT NAME=TouchHand FILE=Textures\TouchHand.bmp GROUP="UserInterface" FLAGS=2 MIPS=OFF

var Texture MouseCursor;

var ScriptedTexture CurrentScriptedTexture;
var bool bOnScriptedTexture;


/*
native(1000) final iterator function TraceTexture
(
	class<actor> BaseClass,
	out actor Actor,
	out name texName,
	out name texGroup,
	out int flags,
	out vector HitLoc,
	out vector HitNorm,
	vector End,
	optional vector Start,
	optional vector Extent
);
*/


// ----------------------------------------------------------------------
// HighlightCenterObject()
// ----------------------------------------------------------------------

function HighlightCenterObject()
{
	local Actor target;
	local Vector HitLoc, HitNormal, StartTrace, EndTrace;

	local name TexName, TexGroup;
	local int Flags;

	local String TexString;

	local bool bWasOnScriptedTexture;
	local ScriptedTexture OldScriptedTexture;

	if (IsInState('Dying'))
		return;

	bWasOnScriptedTexture = bOnScriptedTexture;
	OldScriptedTexture = CurrentScriptedTexture;

	// figure out how far ahead we should trace
	StartTrace = Location;
	EndTrace = Location + (Vector(ViewRotation) * MaxFrobDistance);

	// adjust for the eye height
	StartTrace.Z += BaseEyeHeight;
	EndTrace.Z += BaseEyeHeight;

	bOnScriptedTexture = false;

	// find ScriptedTexture
	foreach TraceTexture(class'Actor', target, texName, texGroup, flags, HitLoc, HitNormal, EndTrace, StartTrace)
	{
		//CurrentScriptedTexture = ScriptedTexture(DynamicLoadObject(String(texGroup) $ "." $ String(texName), Class'ScriptedTexture'));
		CurrentScriptedTexture = ScriptedTexture(DynamicLoadObject(String(texGroup) $ "." $ String(texName), Class'Texture'));
		//ClientMessage("TraceActor is " $ target);
		if (CurrentScriptedTexture != None)
			bOnScriptedTexture = true;
	}

	if (bOnScriptedTexture)
	{
		if (!bWasOnScriptedTexture)
			DeusExRootWindow(RootWindow).Hud.Cross.SetBackground(MouseCursor);
		
		TouchPanel(CurrentScriptedTexture.NotifyActor).OnMouseOver(HitLoc);
		//ClientMessage("Looking at ScriptedTexture " $ texName);
		//ClientMessage("ScriptedTexture.NotifyActor is " $ CurrentScriptedTexture.NotifyActor);
		
		FrobTarget = None;
	}
	else
	{
		if (bWasOnScriptedTexture)
		{
			TouchPanel(OldScriptedTexture.NotifyActor).OnMouseExit();
			DeusExRootWindow(RootWindow).Hud.Cross.SetBackground(Texture'CrossSquare');
		}

		Super.HighlightCenterObject();
	}
}



// ----------------------------------------------------------------------
// ParseLeftClick()
// ----------------------------------------------------------------------

exec function ParseLeftClick()
{
	if (RestrictInput())
		return;

	if (bOnScriptedTexture)
		TouchPanel(CurrentScriptedTexture.NotifyActor).OnMouseClick();
	else
		Super.ParseLeftClick();
}



// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	MouseCursor=Texture'Touch.UserInterface.TouchHand'
}
