//=============================================================================
// TouchPanel
//=============================================================================
class TouchPanel extends Info
	native
	noexport
	abstract;

var() ScriptedTexture ScriptedTexture;

var int MouseX, MouseY;
var bool bMouseOver;

// set by GetSurfaceInfo()
var const	bool		bValidSurfaceInfo;
var const	Vector	BasePoint;
var const	Vector	TextureU;
var const	Vector	TextureV;
var const	int			PanU;
var const	int			PanV;

native(1030) final function SearchSurfaceInfo();

// ----------------------------------------------------------------------
// BeginPlay()
// ----------------------------------------------------------------------

simulated function BeginPlay() 
{ 
	if(ScriptedTexture != None)
	{
		ScriptedTexture.NotifyActor = Self;
		SearchSurfaceInfo();
	}
}


// ----------------------------------------------------------------------
// Destroyed()
// ----------------------------------------------------------------------

simulated function Destroyed() 
{ 
	if(ScriptedTexture != None) 
		ScriptedTexture.NotifyActor = None;
}


// ----------------------------------------------------------------------
// RenderTexture()
// ----------------------------------------------------------------------
  
simulated event RenderTexture(ScriptedTexture Tex) 
{
}


// ----------------------------------------------------------------------
// OnMouseOver()
// ----------------------------------------------------------------------

function OnMouseOver(Vector V)
{
	CalcMouseCoords(V);
	GetPlayerPawn().ClientMessage("OnMouseOver(X=" $ MouseX $ " Y=" $ MouseY $")");
	bMouseOver = true;
}


// ----------------------------------------------------------------------
// OnMouseExit()
// ----------------------------------------------------------------------

function OnMouseExit()
{
	GetPlayerPawn().ClientMessage("OnMouseExit()");
	bMouseOver = false;
}


// ----------------------------------------------------------------------
// OnMouseClick()
// ----------------------------------------------------------------------

function OnMouseClick()
{
	GetPlayerPawn().ClientMessage("OnMouseClick()");
}


// ----------------------------------------------------------------------
// CalcMouseCoords()
// ----------------------------------------------------------------------

function CalcMouseCoords(Vector V)
{
	local Vector A;

	if (!bValidSurfaceInfo)
	{
		Log("No valid Surface Info for " $ self);
		return;
	}

	// TODO
	A = BasePoint - V;

	MouseX = A Dot TextureU;
	MouseY = A Dot TextureV;

	// add pan (+) or (-) ?
	MouseX += PanU;
	MouseY += PanV;

	// make postive
	while (MouseX < 0) MouseX += ScriptedTexture.USize;
	while (MouseY < 0) MouseY += ScriptedTexture.VSize;

	// put in range
	MouseX = MouseX % ScriptedTexture.USize;
	MouseY = MouseY % ScriptedTexture.VSize;
}


// ----------------------------------------------------------------------
// IsMouseInArea()
// ----------------------------------------------------------------------

function bool IsMouseInArea(int x, int y, int w, int h)
{
	return (MouseX > x && MouseX < (x+w)) && (MouseY > y && MouseY < (y+h));
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	RemoteRole=ROLE_SimulatedProxy 
	bStatic=False 
	bAlwaysRelevant=True 
	bNoDelete=True
}
