/*=============================================================================
	Touch.cpp: Touch package implementation.

=============================================================================*/

/*------------------------------------------------------------------------------------
	Dependencies.
------------------------------------------------------------------------------------*/

#include "TouchPrivate.h"

/*------------------------------------------------------------------------------------
	Implementation.
------------------------------------------------------------------------------------*/

IMPLEMENT_PACKAGE(Touch);

IMPLEMENT_CLASS(ATouchPanel);

IMPLEMENT_FUNCTION(ATouchPanel, 1030, execSearchSurfaceInfo);


void LogVector(FVector* v)
{
	GLog->Logf(TEXT("(%f, %f, %f)"), v->X, v->Y, v->Z);
}

/*
    BITFIELD bValidSurfaceInfo:1;
    FVector BasePoint GCC_PACK(4);
    FVector TextureU;
    FVector TextureV;
    FVector PanU;
    FVector PanV;
*/

// ATouchPanel::execSearchSurfaceInfo
void ATouchPanel::execSearchSurfaceInfo(FFrame& Stack, RESULT_DECL)
{
	FBspSurf *MySurf;

	guard(ATouchPanel::execSearchSurfaceInfo);
	P_FINISH;

	bValidSurfaceInfo = false;

	for (int i = 0; i < XLevel->Model->Surfs.Num(); i++)
	{
		if (XLevel->Model->Surfs(i).Texture == ScriptedTexture)
		{
			MySurf = &XLevel->Model->Surfs(i);

			//GLog->Log(TEXT("Found my ScriptedTexture"));
			bValidSurfaceInfo = true;
			break;
		}
	}

	if (bValidSurfaceInfo)
	{
		BasePoint = XLevel->Model->Points(MySurf->pBase);
		TextureU	= XLevel->Model->Vectors(MySurf->vTextureU);
		TextureV	= XLevel->Model->Vectors(MySurf->vTextureV);
		PanU			= MySurf->PanU;
		PanV			= MySurf->PanV;
	}
/*
	GLog->Logf(TEXT("Polys->Element.Num() = %i"), XLevel->Model->Polys->Element.Num());
	GLog->Logf(TEXT("MySurf->Nodes.Num() = %i"), MySurf->Nodes.Num());
	GLog->Logf(TEXT("PanU = %i PanV = %i"), MySurf->PanU, MySurf->PanV);
	GLog->Logf(TEXT("XLevel->Model->Nodes(MySurf->Nodes(0)).NumVertices = %i"), XLevel->Model->Nodes(MySurf->Nodes(0)).NumVertices);

	GLog->Logf(TEXT("Texture Base Point should be:"));
	LogVector(&XLevel->Model->Points(MySurf->pBase));

	GLog->Logf(TEXT("Texture vTextureU should be:"));
	LogVector(&XLevel->Model->Vectors(MySurf->vTextureU));

	GLog->Logf(TEXT("Texture vTextureV should be:"));
	LogVector(&XLevel->Model->Vectors(MySurf->vTextureV));

	GLog->Logf(TEXT("First Point should be:"));
	LogVector(&XLevel->Model->Points(XLevel->Model->Verts(XLevel->Model->Nodes(MySurf->Nodes(0)).iVertPool).pVertex));
*/

	unguardexec;
}



/*
class ENGINE_API UModel : public UPrimitive
{
	// Arrays and subobjects.
	UPolys*									Polys;						// empty in game
	TTransArray<FBspNode>		Nodes;
	TTransArray<FVert>		  Verts;
	TTransArray<FVector>		Vectors;
	TTransArray<FVector>		Points;
	TTransArray<FBspSurf>		Surfs;
	TArray<FLightMapIndex>	LightMap;
	TArray<BYTE>						LightBits;
	TArray<FBox>						Bounds;
	TArray<INT>							LeafHulls;
	TArray<FLeaf>						Leaves;
	TArray<AActor*>					Lights;

	[...]
}

class FBspSurf
{
public:

	// Persistent info.
	UTexture*	Texture;		// 4 Texture map.
	DWORD		PolyFlags;		// 4 Polygon flags.
	INT			pBase;			// 4 Polygon & texture base point index (where U,V==0,0).
	INT			vNormal;		// 4 Index to polygon normal.
	INT			vTextureU;		// 4 Texture U-vector index.
	INT			vTextureV;		// 4 Texture V-vector index.
	INT			iLightMap;		// 4 Light mesh.
	INT			iBrushPoly;		// 4 Editor brush polygon index.
	SWORD		PanU;			// 2 U-Panning value.
	SWORD		PanV;			// 2 V-Panning value.
	ABrush*		Actor;			// 4 Brush actor owning this Bsp surface.
	TArray<FDecal>	Decals;		// 12 Array decals on this surface
	TArray<INT>	Nodes;			// 12 Nodes which make up this surface

	// Functions.
	ENGINE_API friend FArchive& operator<<( FArchive& Ar, FBspSurf& Surf );
};

//
// FBspNode defines one node in the Bsp, including the front and back
// pointers and the polygon data itself.  A node may have 0 or 3 to (MAX_NODE_VERTICES-1)
// vertices. If the node has zero vertices, it's only used for splitting and
// doesn't contain a polygon (this happens in the editor).
//
// vNormal, vTextureU, vTextureV, and others are indices into the level's
// vector table.  iFront,iBack should be INDEX_NONE to indicate no children.
//
// If iPlane==INDEX_NONE, a node has no coplanars.  Otherwise iPlane
// is an index to a coplanar polygon in the Bsp.  All polygons that are iPlane
// children can only have iPlane children themselves, not fronts or backs.
//
class FBspNode // 64 bytes
{
public:

	// Persistent information.
	FPlane			Plane;			// 16 Plane the node falls into (X, Y, Z, W).
	QWORD			ZoneMask;		// 8  Bit mask for all zones at or below this node (up to 64).
	INT				iVertPool;		// 4  Index of first vertex in vertex pool, =iTerrain if NumVertices==0 and NF_TerrainFront.
	INT				iSurf;			// 4  Index to surface information.

	// iBack:  4  Index to node in front (in direction of Normal).
	// iFront: 4  Index to node in back  (opposite direction as Normal).
	// iPlane: 4  Index to next coplanar poly in coplanar list.
	union { INT iBack; INT iChild[1]; };
	        INT iFront;
			INT iPlane;

	INT				iCollisionBound;// 4  Collision bound.
	INT				iRenderBound;	// 4  Rendering bound.
	BYTE			iZone[2];		// 2  Visibility zone in 1=front, 0=back.
	BYTE			NumVertices;	// 1  Number of vertices in node.
	BYTE			NodeFlags;		// 1  Node flags.
	INT				iLeaf[2];		// 8  Leaf in back and front, INDEX_NONE=not a leaf.

};


//
// One vertex associated with a Bsp node's polygon.  Contains a vertex index
// into the level's FPoints table, and a unique number which is common to all
// other sides in the level which are cospatial with this side.
//
class FVert
{
public:
	// Variables.
	INT 	pVertex;	// Index of vertex.
	INT		iSide;		// If shared, index of unique side. Otherwise INDEX_NONE.

	// Functions.
	friend FArchive& operator<< (FArchive &Ar, FVert &Vert)
	{
		guard(FVert<<);
		return Ar << AR_INDEX(Vert.pVertex) << AR_INDEX(Vert.iSide);
		unguard;
	}
};
*/
