//=============================================================================
// TouchGameInfo
//=============================================================================
class TouchGameInfo extends DeusExGameInfo;

// ----------------------------------------------------------------------
// Login()
// ----------------------------------------------------------------------

event playerpawn Login
(
	string Portal,
	string Options,
	out string Error,
	class<playerpawn> SpawnClass
)
{
	local TouchHuman Player;
	local NavigationPoint StartSpot;
	local byte InTeam;
	local DumpLocation dump;

	//DEUS_EX AMSD In non multiplayer games, force JCDenton.
	if (!ClassIsChildOf(SpawnClass, Class'TouchHuman'))
		SpawnClass=class'TouchingDenton';

	Player = TouchHuman(Super(GameInfo).Login(Portal, Options, Error, SpawnClass));

	// If we're traveling across a map on the same mission, 
	// nuke the player's crap and 

	if ((player != None) && (!HasOption(Options, "Loadgame")))
	{
		player.ResetPlayerToDefaults();

		dump = player.CreateDumpLocationObject();

		if ((dump != None) && (dump.HasLocationBeenSaved()))
		{
			dump.LoadLocation();

			player.Pause();
			player.SetLocation(dump.currentDumpLocation.Location);
			player.SetRotation(dump.currentDumpLocation.ViewRotation);
			player.ViewRotation = dump.currentDumpLocation.ViewRotation;
			player.ClientSetRotation(dump.currentDumpLocation.ViewRotation);

			CriticalDelete(dump);
		}
		else
		{
			InTeam    = GetIntOption( Options, "Team", 0 ); // Multiplayer now, defaults to Team_Unatco=0
         if (Level.NetMode == NM_Standalone)			
            StartSpot = FindPlayerStart( None, InTeam, Portal );
         else
            StartSpot = FindPlayerStart( Player, InTeam, Portal );

			player.SetLocation(StartSpot.Location);
			player.SetRotation(StartSpot.Rotation);
			player.ViewRotation = StartSpot.Rotation;
			player.ClientSetRotation(player.Rotation);
		}
	}
	return player;
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
}
