//=============================================================================
// TouchKeypad
//=============================================================================
class TouchKeypad extends TouchPanel;

var int Numbers[4];
var int NumbersEntered;

var Texture NumberTexture;


// ----------------------------------------------------------------------
// BeginPlay()
// ----------------------------------------------------------------------

simulated function BeginPlay() 
{ 
	Super.BeginPlay();

	NumberTexture = Texture(DynamicLoadObject("TouchTextures.TouchKeypadNumb", Class'Texture'));
}


// ----------------------------------------------------------------------
// RenderTexture()
// ----------------------------------------------------------------------
  
simulated event RenderTexture(ScriptedTexture T)
{
	local int i;

	Super.RenderTexture(T);

	// draw numbers
	for (i = 0; i < NumbersEntered; i++)
		RenderNumber((i * 16) + 32, 8, Numbers[i], T);

}


// ----------------------------------------------------------------------
// RenderNumner()
// ----------------------------------------------------------------------

function RenderNumber(int x, int y, int n, ScriptedTexture T)
{
	local int tx, ty;

	tx = (n % 4) * 16;
	ty = (n / 4) * 16;

	T.DrawTile(x, y, 16, 16, tx, ty, 16, 16, NumberTexture, false);
}


// ----------------------------------------------------------------------
// ButtonActivated()
// ----------------------------------------------------------------------

function ButtonActivated(int Button)
{
	// clear button
	if (Button == 10)
	{
		NumbersEntered = 0;
	}

	// 0 - 9
	else
	{
		if (NumbersEntered == 4)
			NumbersEntered = 0;

		Numbers[NumbersEntered++] = Button;
	}
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	OverTextureString="TouchTextures.TouchKeypadOver"
	ButtonCount=11
	Button(0)=(X=0,Y=32,W=32,H=32)
	Button(1)=(X=32,Y=32,W=32,H=32)
	Button(2)=(X=64,Y=32,W=32,H=32)
	Button(3)=(X=96,Y=32,W=32,H=32)
	Button(4)=(X=0,Y=64,W=32,H=32)
	Button(5)=(X=32,Y=64,W=32,H=32)
	Button(6)=(X=64,Y=64,W=32,H=32)
	Button(7)=(X=96,Y=64,W=32,H=32)
	Button(8)=(X=0,Y=96,W=32,H=32)
	Button(9)=(X=32,Y=96,W=32,H=32)
	Button(10)=(X=64,Y=96,W=64,H=32)
}
