//=============================================================================
// TouchPanel
//=============================================================================
class TouchPanel extends Info
	native
	noexport
	abstract;

struct STPButton
{
	var int X, Y, W, H;
};


var(Button) STPButton	Button[16];
var(Button) int				ButtonCount;
var(Button) String		OverTextureString;

var Texture OverTexture;

var() ScriptedTexture ScriptedTexture;

var int MouseX, MouseY;
var bool bMouseOver;

// set by GetSurfaceInfo()
var const	bool		bValidSurfaceInfo;
var const	Vector	BasePoint;
var const	Vector	TextureU;
var const	Vector	TextureV;
var const	int			PanU;
var const	int			PanV;

native(1030) final function SearchSurfaceInfo();

/*
native(473) final function DrawTile(
	float X
	float Y
	float XL
	float YL
	float U
	float V
	float UL
	float VL
	Texture Tex
	bool bMasked
);
*/



// ----------------------------------------------------------------------
// BeginPlay()
// ----------------------------------------------------------------------

simulated function BeginPlay() 
{ 
	if(ScriptedTexture != None)
	{
		ScriptedTexture.NotifyActor = Self;
		SearchSurfaceInfo();

		OverTexture = Texture(DynamicLoadObject(OverTextureString, Class'Texture'));
	}
}


// ----------------------------------------------------------------------
// Destroyed()
// ----------------------------------------------------------------------

simulated function Destroyed() 
{ 
	if(ScriptedTexture != None) 
		ScriptedTexture.NotifyActor = None;
}


// ----------------------------------------------------------------------
// RenderTexture()
// ----------------------------------------------------------------------

simulated event RenderTexture(ScriptedTexture T) 
{
	local int i;

	if (!bMouseOver)
		return;

	// draw highlighted button		
	if (IsOnButton(i))
		T.DrawTile(Button[i].X, Button[i].Y, Button[i].W, Button[i].H, Button[i].X, Button[i].Y, Button[i].W, Button[i].H, OverTexture, false);
}


// ----------------------------------------------------------------------
// IsOnButton()
// ----------------------------------------------------------------------

function bool IsOnButton(out int Id)
{
	local int i;

	for (i = 0; i < ButtonCount; i++)
	{
		if (IsMouseInArea(Button[i].X, Button[i].Y, Button[i].W, Button[i].H))
		{
			Id = i;
			return true;
		}
	}
	return false;
}


// ----------------------------------------------------------------------
// OnMouseOver()
// ----------------------------------------------------------------------

function OnMouseOver(Vector V)
{
	CalcMouseCoords(V);

//	GetPlayerPawn().ClientMessage("OnMouseOver(X=" $ MouseX $ " Y=" $ MouseY $")");
	bMouseOver = true;
}


// ----------------------------------------------------------------------
// OnMouseExit()
// ----------------------------------------------------------------------

function OnMouseExit()
{
	//GetPlayerPawn().ClientMessage("OnMouseExit()");

	bMouseOver = false;
}


// ----------------------------------------------------------------------
// OnMouseClick()
// ----------------------------------------------------------------------

function OnMouseClick()
{
	local int i;
	//GetPlayerPawn().ClientMessage("OnMouseClick()");

	Log("BasePoint: " $ BasePoint);
	Log("TextureU: " $ TextureU);
	Log("TextureV: " $ TextureV);
	Log("PanU: " $ PanU);
	Log("PanV: " $ PanV);

	if (IsOnButton(i))
		ButtonActivated(i);
}


// ----------------------------------------------------------------------
// CalcMouseCoords()
// ----------------------------------------------------------------------

function CalcMouseCoords(Vector V)
{
	local Vector A;

	if (!bValidSurfaceInfo)
	{
		Log("No valid Surface Info for " $ self);
		return;
	}

	// this code will always... and always break.. grar!
	A = BasePoint - V;

//	MouseX = Abs((A Dot TextureU) + PanU);
//	MouseY = Abs((A Dot TextureV) + PanV);

//	MouseX = Abs(A Dot TextureU);
//	MouseY = Abs(A Dot TextureV);

	MouseX = Abs(A Dot TextureU);
	MouseY = A Dot TextureV;

	// add pan (+) or (-) ?
	MouseX += PanU;
	MouseY += PanV;

	// make postive
	while (MouseX < 0) MouseX += ScriptedTexture.USize;
	while (MouseY < 0) MouseY += ScriptedTexture.VSize;

	// put in range
	MouseX = MouseX % ScriptedTexture.USize;
	MouseY = MouseY % ScriptedTexture.VSize;

	MouseY = ScriptedTexture.VSize - MouseY;
}


// ----------------------------------------------------------------------
// IsMouseInArea()
// ----------------------------------------------------------------------

function bool IsMouseInArea(int x, int y, int w, int h)
{
	return (MouseX >= x && MouseX < (x+w)) && (MouseY >= y && MouseY < (y+h));
}


// ----------------------------------------------------------------------
// ButtonActivated()
// ----------------------------------------------------------------------

function ButtonActivated(int Button)
{
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	RemoteRole=ROLE_SimulatedProxy 
	bStatic=False 
	bAlwaysRelevant=True 
	bNoDelete=True
	ButtonCount=0
}
