//=============================================================================
// AdaptiveArmor.
//=============================================================================
class AdaptiveArmor extends ChargedPickup;

#exec OBJ LOAD FILE=Effects

var Weapon UDamageWeapon;
var Sound FireSound;
var localized String MPExpireMessage;
var localized String MPItemName;
var localized String Ddamage;


simulated function PreBeginPlay()
{
    	Super.PreBeginPlay();
    	if ( ((Level.Game != None) && Level.Game.bDeathMatch) || (Level.NetMode != NM_Standalone) )
    	{
        		bOneUseOnly = True;
        		bAutoActivate = True;
        		bCanHaveMultipleCopies = False;
        		AmbientGlow = 255;
						ExpireMessage = MPExpireMessage;
     				ItemName = MPItemName;

//-!!!!!!!!!!!!!!!------------------------------------
				    Mesh=Mesh'DeusExDeco.DXLogo';
						PickUpViewMesh=Mesh'DeusExDeco.DXLogo';
				    Texture=Texture'AlarmLightTex7';
						DrawScale=0.35;
            PickUpViewScale=0.35;
						SetCollisionSize(CollisionRadius, 25);
				    SetPhysics(PHYS_Falling);
						SetLocation(Location + vect(0,0,200));
						LightType=LT_Steady;
						LightRadius=2;
						LightBrightness=250;
						LightHue=145;
						LightSaturation=35;
						LightEffect=LE_NonIncidence;
//-------------------------------------------------------
    	}
}

function UsedUp()
{
    	if (Level.Game.bDeathMatch || (Level.NetMode != NM_Standalone))
    	{
		if ( UDamageWeapon != None )
        		{
            			if ( UDamageWeapon.IsA('WeaponPistol') || UDamageWeapon.IsA('WeaponAssaultGun')
               				|| UDamageWeapon.IsA('WeaponAssaultShotgun') || UDamageWeapon.IsA('WeaponSawedOffShotgun') 
				|| UDamageWeapon.IsA('WeaponHideAGun') )
            			{
                 				UDamageWeapon.MultiSkins[0] = None;
                 				UDamageWeapon.MultiSkins[1] = None;
                 				UDamageWeapon.MultiSkins[2] = None;
                 				UDamageWeapon.MultiSkins[3] = None;
                 				UDamageWeapon.Style = UDamageWeapon.Default.Style;
                 				UDamageWeapon.bUnlit = UDamageWeapon.Default.bUnlit;
            			}
            			else
	         			UDamageWeapon.SetDefaultDisplayProperties();
        		}
		
		if ( Pawn(Owner) != None )
                 		Pawn(Owner).DamageScaling = 1.0;
      
		bActive = False;

		if ( Owner.Inventory != None )
		{
		 	Owner.Inventory.SetOwnerDisplay();
		 	Owner.Inventory.ChangedWeapon();
		}
    	}
    	Super.UsedUp();
}

function SetUDamageWeapon()
{      
	if ( !bActive )
		return;
	
	// Make old weapon normal again.
	if ( UDamageWeapon != None )
        	{
            		if ( UDamageWeapon.IsA('WeaponPistol') || UDamageWeapon.IsA('WeaponAssaultGun')
               			|| UDamageWeapon.IsA('WeaponAssaultShotgun') || UDamageWeapon.IsA('WeaponSawedOffShotgun')
			|| UDamageWeapon.IsA('WeaponHideAGun') )
            		{
                 			UDamageWeapon.MultiSkins[0] = None;
                 			UDamageWeapon.MultiSkins[1] = None;
                 			UDamageWeapon.MultiSkins[2] = Texture'BlackMaskTex';
                 			UDamageWeapon.MultiSkins[3] = None;
                 			UDamageWeapon.Style = UDamageWeapon.Default.Style;
                 			UDamageWeapon.bUnlit = UDamageWeapon.Default.bUnlit;
            		}
            		else
	         		UDamageWeapon.SetDefaultDisplayProperties();
        	}
					
	UDamageWeapon = Pawn(Owner).Weapon;
	// Make new weapon cool.
	if ( UDamageWeapon != None )
        	{
           		//because of the muzzleflash multiskins...
           		if ( UDamageWeapon.IsA('WeaponPistol') || UDamageWeapon.IsA('WeaponAssaultGun')
              			|| UDamageWeapon.IsA('WeaponAssaultShotgun') || UDamageWeapon.IsA('WeaponSawedOffShotgun') 
			|| UDamageWeapon.IsA('WeaponHideAGun') )
           		{
                 			UDamageWeapon.MultiSkins[0] = EffectTexture;
                 			UDamageWeapon.MultiSkins[1] = EffectTexture;
                 			UDamageWeapon.MultiSkins[2] = Texture'BlackMaskTex';
                 			UDamageWeapon.MultiSkins[3] = EffectTexture;
                 			UDamageWeapon.Style = STY_Translucent;
                 			UDamageWeapon.bUnlit = true;
           		}
           		else
	         		UDamageWeapon.SetDisplayProperties(ERenderStyle.STY_Translucent, EffectTexture, true, true);
        	}
}

state Activated
{
	function Timer()
	{
		local DeusExPlayer Player;

		Player = DeusExPlayer(Owner);
                		FireEffect();
		if ( Player != None )
		{
			ChargedPickupUpdate(Player);
			Charge -= CalcChargeDrain(Player);                   
		}
                		else
                        		Charge -= 1;
                		if (Charge <= 0)
			UsedUp();
	}

        	function SetOwnerDisplay()
	{
               		if( Inventory != None )
		    	Inventory.SetOwnerDisplay();
                		if ( Level.Game.bDeathMatch || (Level.NetMode != NM_Standalone) )
		    	SetUDamageWeapon();
	}

	function ChangedWeapon()
	{
               		if( Inventory != None )
		    	Inventory.ChangedWeapon();
                		if ( Level.Game.bDeathMatch || (Level.NetMode != NM_Standalone) )
		    	SetUDamageWeapon();
	}

        	function BeginState()
	{         
            		Super.BeginState();
            		if ( Level.Game.bDeathMatch || (Level.NetMode != NM_Standalone) )
            		{
			Pawn(Owner).DamageScaling = 3.0;
                			if ( Owner.IsA('DeusExPlayer') )
                    			DeusExPlayer(Owner).MultiplayerNotifyMsg( DeusExPlayer(Owner).MPMSG_DD,, Ddamage );
			SetUDamageWeapon();	
            		}
	}
}

simulated function FireEffect()
{  
   	if ( (((Level.Game != None) && Level.Game.bDeathMatch) || (Level.NetMode != NM_Standalone)) && (Pawn(Owner) != None) )
   	{
      		if ( (UDamageWeapon != None) && (UDamageWeapon.IsInState('NormalFire') || UDamageWeapon.IsInState('ClientFiring')
         			|| UDamageWeapon.IsInState('AltFiring') || UDamageWeapon.IsInState('ClientAltFiring')) )
         			if ( TimerRate - TimerCounter < 10 ) 
				Pawn(Owner).PlaySound(FireSound, SLOT_Misc, 8);
   	}
}         
   
simulated function Destroyed()
{
   	if ( Pawn(Owner) != None )
        		Pawn(Owner).DamageScaling = 1.0;
      	Super.Destroyed();
}

defaultproperties
{
     FireSound=Sound'DeusEx.Weapons.RailStealthFire'
     MPExpireMessage="Damage Amplifier power supply used up"
     MPItemName="Damage Amplifier"
     Ddamage="DOUBLE DAMAGE!"
     skillNeeded=Class'DeusEx.SkillEnviro'
     bOneUseOnly=False
     ActivateSound=Sound'DeusExSounds.Augmentation.CloakUp'
     DeActivateSound=Sound'DeusExSounds.Augmentation.CloakDown'
     LoopSound=Sound'DeusExSounds.Pickup.SuitLoop'
     EffectTexture=FireTexture'Effects.Electricity.Nano_SFX'
     MaxCharge=2500
     ChargedIcon=Texture'DeusExUI.Icons.ChargedIconArmorAdaptive'
     ExpireMessage="Thermoptic camo power supply used up"
     ItemName="Thermoptic Camo"
     ItemArticle="some"
     RespawnTime=120.000000
     PlayerViewOffset=(X=30.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'DeusExItems.AdaptiveArmor'
     PickupViewMesh=LodMesh'DeusExItems.AdaptiveArmor'
     ThirdPersonMesh=LodMesh'DeusExItems.AdaptiveArmor'
     Charge=500
     MaxDesireability=2.500000
     LandSound=Sound'DeusExSounds.Generic.PaperHit2'
     Icon=Texture'DeusExUI.Icons.BeltIconArmorAdaptive'
     largeIcon=Texture'DeusExUI.Icons.LargeIconArmorAdaptive'
     largeIconWidth=35
     largeIconHeight=49
     Description="Integrating woven fiber-optics and an advanced computing system, thermoptic camo can render an agent invisible to both humans and bots by dynamically refracting light and radar waves; however, the high power drain makes it impractial for more than short-term use, after which the circuitry is fused and it becomes useless."
     beltDescription="THRM CAMO"
     Mesh=LodMesh'DeusExItems.AdaptiveArmor'
     CollisionRadius=11.500000
     CollisionHeight=13.810000
     Mass=30.000000
     Buoyancy=20.000000
}
