//=============================================================================
// Arena.
//=============================================================================

class Arena expands Mutator
	abstract;

var name WeaponName, AmmoName;
var string WeaponString, AmmoString;

function AddMutator(Mutator M)
{
	if ( M.IsA('Arena') )
	{
		log(M$" not allowed (already have an Arena mutator)");
		return; //only allow one arena mutator
	}
	Super.AddMutator(M);
}

function bool AlwaysKeep(Actor Other)
{
	local bool bTemp;

	if ( Other.IsA(WeaponName) )
	{
		return true;
	}
	if ( Other.IsA(AmmoName) )
	{
		return true;
	}

	if ( NextMutator != None )
		return ( NextMutator.AlwaysKeep(Other) );
	return false;
}

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
	if (Other.IsA('BioelectricCell') || Other.IsA('Lockpick') 
      	|| Other.IsA('Multitool') || Other.IsA('AugmentationCannister') || Other.IsA('AugmentationUpgradeCannister') )
      		return false;

	if ( Other.IsA('Weapon') )
	{
		if (WeaponString == "")
			return false;
		else if ((WeaponString != "") && !Other.IsA(WeaponName))
		{
			//Level.Game.bCoopWeaponMode = false;
			ReplaceWith(Other, WeaponString);
                        		return false;
		}
	}

        	if ( Other.IsA('Ammo') )
	{
		if (AmmoString == "")
			return false;
		else if ((AmmoString != "") && !Other.IsA(AmmoName))
		{
			ReplaceWith(Other, AmmoString);
                        		return false;
		}
	}
	        
	bSuperRelevant = 0;
	return true;
}

function bool ReplaceWith(actor Other, string aClassName)
{
	local Actor A;
	local class<Actor> aClass;

	if ( Other.IsA('Inventory') && (Other.Location == vect(0,0,0)) )
		return false;
	aClass = class<Actor>(DynamicLoadObject(aClassName, class'Class'));
	if ( aClass != None )
		A = Spawn(aClass,,Other.tag,Other.Location, Other.Rotation);
	if ( Other.IsA('Inventory') )
	{
		if ( Inventory(Other).MyMarker != None )
		{
			Inventory(Other).MyMarker.markedItem = Inventory(A);
			if ( Inventory(A) != None )
			{
				Inventory(A).MyMarker = Inventory(Other).MyMarker;
				A.SetLocation(A.Location 
					+ (A.CollisionHeight - Other.CollisionHeight) * vect(0,0,1));
			}
			Inventory(Other).MyMarker = None;
		}
		else if ( A.IsA('Inventory') )
		{
			Inventory(A).bHeldItem = true;
                        		Inventory(A).Respawntime = 0.0;
			//Inventory(A).Respawntime = Inventory(A).Default.Respawntime;
		}
	}
	if ( A != None )
	{
		A.event = Other.event;
		A.tag = Other.tag;
                	if (A.IsA('Weapon') && !A.IsA('WeaponGEPGun')  && !A.IsA('WeaponMiniCrossbow')) 
                   		A.SetRotation(Rotation + rot(0,0,16384));
                	else
                   		A.SetRotation(Rotation);
		return true;
	}
	return false;
}

defaultproperties
{
}
