//=============================================================================
// ArmorEffect.
//=============================================================================
class ArmorEffect extends Effects;

var int FatnessOffset;

simulated function Tick(float DeltaTime)
{
	local int IdealFatness;

	if ( (Level.NetMode == NM_DedicatedServer) || (Owner == None) )
		return;

	IdealFatness = Owner.Fatness; // Convert to int for safety.
	IdealFatness += FatnessOffset;

	if ( Fatness > IdealFatness )
		Fatness = Max(IdealFatness, Fatness - 130 * DeltaTime);
	else
		Fatness = Min(IdealFatness, 255);
}

defaultproperties
{
     FatnessOffset=29
     bAnimByOwner=True
     bTrailerSameRotation=True
     Physics=PHYS_Trailer
     DrawType=DT_Mesh
     Style=STY_Translucent
     Texture=FireTexture'Effects.liquid.Virus_SFX'
     AmbientGlow=64
     Fatness=157
     bUnlit=True
     bMeshEnviroMap=True
     bOwnerNoSee=True
}
