//=============================================================================
// AugCloak.
//=============================================================================
class AugCloak extends Augmentation;

var float mpAugValue;
var float mpEnergyDrain;

state Active
{
	function Tick(Float DeltaTime)
	{
		TurnOnTranslucency();
	}

	function EndState()
	{
		TurnOffTranslucency();
	}	
Begin:
	if ((Player.inHand != None) && (Player.inHand.IsA('DeusExWeapon')))
		Player.ServerConditionalNotifyMsg( Player.MPMSG_NoCloakWeapon );
	Player.PlaySound(Sound'CloakUp', SLOT_Interact, 0.85, ,768,1.0);
}

function Deactivate()
{
	Player.PlaySound(Sound'CloakDown', SLOT_Interact, 0.85, ,768,1.0);
	Super.Deactivate();
}

function TurnOnTranslucency()
{
	if ( Level.Game.bDeathMatch || (Level.NetMode != NM_StandAlone) )
		return;

	if ( Player.Style != STY_Translucent )
	{
		Player.Style = STY_Translucent;
		if ( Player.IsA('JCDentonMale') )
      		{
         			Player.MultiSkins[6] = Texture'BlackMaskTex';
         			Player.MultiSkins[7] = Texture'BlackMaskTex';
      		}
	}

	if ( (Player.inHand != None) && (Player.inHand.Style != STY_Translucent) )
	{
		Player.inHand.Style = STY_Translucent;
	}
}

function TurnOffTranslucency()
{	
	local Inventory Inv, PlayerInv;

	PlayerInv = Player.Inventory;

	if ( Level.Game.bDeathMatch || (Level.NetMode != NM_StandAlone) )
		return;

	Player.Style = Player.Default.Style;
	if ( Player.IsA('JCDentonMale') )
      	{
         		Player.MultiSkins[6] = Player.Default.MultiSkins[6];
         		Player.MultiSkins[7] = Player.Default.MultiSkins[7];
      	}
		
	if ( Player.inHand != None ) 
	{
		Player.inHand.Style = Player.inHand.Default.Style;
	}

	if (PlayerInv != None)
	{
   	    	for (Inv = PlayerInv; Inv != None; Inv = Inv.Inventory)
      			Inv.Style = Inv.Default.Style;
	}
}

simulated function float GetEnergyRate()
{
	return EnergyRate * LevelValues[CurrentLevel];
}

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	// If this is a netgame, then override defaults
	if ( Level.NetMode != NM_StandAlone )
	{
		LevelValues[3] = mpAugValue;
		EnergyRate = mpEnergyDrain;
                	AugmentationLocation = LOC_Eye;
	}
}

defaultproperties
{
     mpAugValue=1.000000
     mpEnergyDrain=40.000000
     EnergyRate=300.000000
     Icon=Texture'DeusExUI.UserInterface.AugIconCloak'
     smallIcon=Texture'DeusExUI.UserInterface.AugIconCloak_Small'
     AugmentationName="Cloak"
     Description="Subdermal pigmentation cells allow the agent to blend with their surrounding environment, rendering them effectively invisible to observation by organic hostiles and automated detection systems -- bots, cameras, turrets, laser alarm systems.|n|nTECH ONE: Power drain is normal.|n|nTECH TWO: Power drain is reduced slightly.|n|nTECH THREE: Power drain is reduced moderately.|n|nTECH FOUR: Power drain is reduced significantly."
     MPInfo="When active, you are invisible to enemies, turrets and cameras."
     LevelValues(0)=1.000000
     LevelValues(1)=0.830000
     LevelValues(2)=0.670000
     LevelValues(3)=0.500000
     AugmentationLocation=LOC_Subdermal
     MPConflictSlot=7
}
