//=============================================================================
// AugCombat.
//=============================================================================
class AugCombat extends Augmentation;

var float mpAugValue;
var float mpEnergyDrain;

state Active
{
Begin:
	Player.MaxFrobDistance = LevelValues[CurrentLevel];
}

function Deactivate()
{
	Player.MaxFrobDistance = Player.Default.MaxFrobDistance;
	Super.Deactivate();
}

simulated function float GetEnergyRate()
{	
	local float MyEnergyRate;

	MyEnergyRate = EnergyRate;
	EnergyRate = 0;
	return MyEnergyRate;
}

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	// If this is a netgame, then override defaults
	if ( Level.NetMode != NM_StandAlone )
	{
		LevelValues[3] = mpAugValue;
	}
}

defaultproperties
{
     mpAugValue=800.000000
     EnergyRate=0.000000
     Icon=Texture'DeusExUI.UserInterface.AugIconCombat'
     smallIcon=Texture'DeusExUI.UserInterface.AugIconCombat_Small'
     bTurnOffWhenTravel=True
     AugmentationName="Telekinesis"
     Description="Sorting rotors accelerate calcium ion concentration in the sarcoplasmic reticulum, increasing the distance within the agent can interact with surrounding envoronment.|n|nTECH ONE: The interacting distance is increased slightly.|n|nTECH TWO: The interacting distance is increased moderately.|n|nTECH THREE: The interacting distance is increased significantly.|n|nTECH FOUR: An agent's interacting ability is inhumanly strong."
     MPInfo="When active, you can interact with surrounding environment on bigger distances.  Energy Drain: High"
     LevelValues(0)=400.000000
     LevelValues(1)=800.000000
     LevelValues(2)=1600.000000
     LevelValues(3)=3200.000000
     AugmentationLocation=LOC_Arm
     MPConflictSlot=1
     LoopSound=None
}
