//=============================================================================
// AugEMP.
//=============================================================================
class AugEMP extends Augmentation;

var float mpAugValue;
var float mpEnergyDrain;

state Active
{
Begin:
	Player.PlaySound(Sound'CloakUp', SLOT_Interact, 0.85, ,768,1.0);
	Player.GotoState('AugFlying');
}

function Deactivate()
{
	if ( !Player.IsInState('Dying') )
		Player.GotoState('PlayerWalking');
	Player.PlaySound(Sound'CloakDown', SLOT_Interact, 0.85, ,768,1.0);
	Super.Deactivate();
}

simulated function float GetEnergyRate()
{
	return EnergyRate * LevelValues[CurrentLevel];
}

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	// If this is a netgame, then override defaults
	if ( Level.NetMode != NM_StandAlone )
	{
		LevelValues[3] = mpAugValue;
	}
}

defaultproperties
{
     mpAugValue=0.050000
     EnergyRate=750.000000
     Icon=Texture'DeusExUI.UserInterface.AugIconVision'
     smallIcon=Texture'DeusExUI.UserInterface.AugIconVision_Small'
     bTurnOffWhenTravel=True
     AugmentationName="Levitation"
     Description="Nanoscale EMP generators partially protect the agent from the gravitation power and allows him/her to fly.|n|nTECH ONE: Power drain is normal.|n|nTECH TWO: Power drain is reduced slightly.|n|nTECH THREE: Power drain is reduced moderately.|n|nTECH FOUR: Power drain is reduced significantly."
     MPInfo="When active, you can fly.  Energy Drain: Very High"
     LevelValues(0)=1.000000
     LevelValues(1)=0.830000
     LevelValues(2)=0.670000
     LevelValues(3)=0.500000
     AugmentationLocation=LOC_Subdermal
     MPConflictSlot=4
}
