//=============================================================================
// AugEnviro.
//=============================================================================
class AugEnviro extends Augmentation;

var float mpAugValue;
var float mpEnergyDrain;
var bool bChargeNeeded;

state Active
{
Begin:
Loop:	
	Sleep(1.0);
	RechargeEquipment();
	Goto('Loop');
}

function Deactivate()
{
	Super.Deactivate();
}

simulated function RechargeEquipment()
{
	local Inventory Inv;
	local ChargedPickup Equipment;
	local int MaxChargeAmount;	

	for ( Inv=Player.Inventory; Inv!=None; Inv=Inv.Inventory )
	{
		if ( Inv.IsA('ChargedPickup') /*&& Inv.bActive*/ )
		{
			Equipment = ChargedPickup(Inv);
			if ( Equipment != None )
			{	
				if ( CurrentLevel == 3 )
				{
					MaxChargeAmount = Equipment.MaxCharge;
					//log("MaxChargeAmount = "$Equipment.MaxCharge$"");
				}
				else
				{
					MaxChargeAmount = Equipment.Default.Charge;
					//log("MaxChargeAmount = Default");
				}
				if ( Equipment.bActive )
				{
					if ( Equipment.Charge < MaxChargeAmount )
					{
						bChargeNeeded = True;
						//log("bChargeNeeded=True for "$Equipment$"");
						Equipment.Charge += Int(LevelValues[CurrentLevel]);
						if ( Equipment.Charge >= MaxChargeAmount )
							Equipment.Charge = MaxChargeAmount;
					}
					else
						bChargeNeeded = False;
				}
				else
				{
					bChargeNeeded = False;	
					//log("bChargeNeeded=False for "$Equipment$" because bActive=False");
				}
			}
			else
			{
				bChargeNeeded = False;	
				//log("bChargeNeeded=False bacause Equipment == None");
			}
			
		}
	}
}

simulated function float GetEnergyRate()
{	
	if ( bChargeNeeded )        
                	EnergyRate = 300.000000;       	
        	else
	               	EnergyRate = Default.EnergyRate;
         	
	return EnergyRate;
}

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	// If this is a netgame, then override defaults
	if ( Level.NetMode != NM_StandAlone )
	{
		LevelValues[3] = mpAugValue;
		AugmentationLocation = LOC_Subdermal;
	}
}

defaultproperties
{
     mpAugValue=0.100000
     bAutomatic=True
     EnergyRate=0.000000
     Icon=Texture'DeusExUI.UserInterface.AugIconEnviro'
     smallIcon=Texture'DeusExUI.UserInterface.AugIconEnviro_Small'
     AugmentationName="Equipment Recharger"
     Description="Nanoformer generators below the skin recharge the agent's equipment, such as armors, tech goggles and rebreathers. On the highest level recharge occurs even beyond the equipments factory default.|n|nTECH ONE: Recharging occurs at a normal rate.|n|nTECH TWO: Recharging occurs at a slightly faster rate.|n|nTECH THREE: Recharging occurs at a moderately faster rate.|n|nTECH FOUR: Recharging occurs at a significantly faster rate."
     MPInfo="When active, you can recharge your armors. Energy Drain: High"
     LevelValues(0)=5.000000
     LevelValues(1)=10.000000
     LevelValues(2)=20.000000
     LevelValues(3)=40.000000
     AugmentationLocation=LOC_Torso
     MPConflictSlot=2
     LoopSound=None
}
