//=============================================================================
// AugMuscle.
//=============================================================================
class AugMuscle extends Augmentation;

var float mpAugValue;
var float mpEnergyDrain;

state Active
{
Begin:
}

function Deactivate()
{
	Super.Deactivate();

	// check to see if the player is carrying something too heavy for him
	if ( Player.CarriedDecoration != None )
		if ( !Player.CanBeLifted(Player.CarriedDecoration) )
			Player.DropDecoration();
}

simulated function float GetEnergyRate()
{	
	local DeusExDecoration deco;
	local DeusExWeapon weapon;

	deco = DeusExDecoration(Player.CarriedDecoration);
	weapon = DeusExWeapon(Player.Weapon);

         	if ( (deco != None) && (deco.Mass > 50) )                             
                	EnergyRate=60.000000;
	else if ( (weapon != None) && weapon.bHandToHand &&
         		(weapon.IsInState('NormalFire') || weapon.IsInState('ClientFiring') 
		|| weapon.IsInState('AltFiring') || weapon.IsInState('ClientAltFiring')) )  
                	EnergyRate = 200.000000;            
         	else 
		EnergyRate = Default.EnergyRate;

	return EnergyRate;
}

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( Level.NetMode != NM_StandAlone )
	{
		LevelValues[3] = mpAugValue;
	             	AugmentationLocation = LOC_Leg;
	}
}

defaultproperties
{
     mpAugValue=2.000000
     bAutomatic=True
     EnergyRate=0.000000
     Icon=Texture'DeusExUI.UserInterface.AugIconMuscle'
     smallIcon=Texture'DeusExUI.UserInterface.AugIconMuscle_Small'
     AugmentationName="Muscle Strength"
     Description="Muscle strength is amplified with ionic polymeric gel myofibrils that allow the agent to push and lift extraordinarily heavy objects and multiplying the damage inflicted in melee combat.|n|nTECH ONE: Muscle strength and effectiveness of melee weapons are increased slightly.|n|nTECH TWO: Muscle strength and effectiveness of melee weapons are increased moderately.|n|nTECH THREE: Muscle strength and effectiveness of melee weapons are increased significantly.|n|nTECH FOUR: An agent is inhumanly strong and the melee weapons are almost instantly lethal."
     MPInfo="When active, you can pick up large crates and do double damage with melee weapons.  Energy Drain: Low"
     LevelValues(0)=1.250000
     LevelValues(1)=1.500000
     LevelValues(2)=1.750000
     LevelValues(3)=2.000000
     AugmentationLocation=LOC_Arm
     MPConflictSlot=1
     LoopSound=None
}
