//=============================================================================
// AugRadarTrans.
//=============================================================================
class AugRadarTrans extends Augmentation;

var float mpAugValue;
var float mpEnergyDrain;
var HoloDenton jc;

replication
{
    	reliable if (Role < ROLE_Authority)
		SpawnHologram, DestroyHologram;
}

state Active
{
Begin:
	SpawnHologram();
	if ( jc == None )
	{
		Player.ClientMessage("Hologram creation failed!");
		Deactivate();
	}
}

function Deactivate()
{
	DestroyHologram();
	Super.Deactivate();
}

simulated function SpawnHologram()
{
	local Pawn P;

	for ( P=Player.Level.PawnList; P!=None; P=P.NextPawn )
	{
		if ( P.IsA('HoloDenton') )
			HoloDenton(P).Explode();
	}

	if ( jc == None )
		jc = Player.Spawn(Class'HoloDenton',,,Player.Location + 800 * Vector(Player.Rotation) + vect(0,0,1) * 45 );
	if ( jc != None )
		jc.SetSkin(Player);
}

simulated function DestroyHologram()
{
	local Pawn P;

	if ( jc != None )
	{
		jc.Explode();
		jc = None;
	}

	for ( P=Player.Level.PawnList; P!=None; P=P.NextPawn )
	{
		if ( P.IsA('HoloDenton') )
			HoloDenton(P).Explode();
	}
}

function float GetEnergyRate()
{
	return EnergyRate * LevelValues[CurrentLevel];
}

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	// If this is a netgame, then override defaults
	if ( Level.NetMode != NM_StandAlone )
	{
		LevelValues[3] = mpAugValue;
		EnergyRate = mpEnergyDrain;
      		AugmentationLocation = LOC_Torso;
	}
}

defaultproperties
{
     mpAugValue=0.500000
     mpEnergyDrain=30.000000
     EnergyRate=450.000000
     Icon=Texture'DeusExUI.UserInterface.AugIconRadarTrans'
     smallIcon=Texture'DeusExUI.UserInterface.AugIconRadarTrans_Small'
     bTurnOffWhenTravel=True
     AugmentationName="Hologram System"
     Description="Nanoformer subdermal cells creates a hologram copy of the agent. The hologram can simulate basic human reactions. Skilled agents can use the hologram system to manipulate enemy agents, robots and electronic devices. Deactivation of the hologram system creates a Stun-EMP explosion.|n|nTECH ONE: Power drain is normal.|n|nTECH TWO: Power drain is reduced slightly.|n|nTECH THREE: Power drain is reduced moderately.|n|nTECH FOUR: Power drain is reduced significantly."
     MPInfo="When active, you spawn a hologram copy."
     LevelValues(0)=1.000000
     LevelValues(1)=0.830000
     LevelValues(2)=0.660000
     LevelValues(3)=0.500000
     AugmentationLocation=LOC_Subdermal
     MPConflictSlot=7
}
