//=============================================================================
// AugShield.
//=============================================================================
class AugShield extends Augmentation;

var float mpAugValue;
var float mpEnergyDrain;

state Active
{
Begin:
}

function Deactivate()
{
	Super.Deactivate();
}

simulated function float GetEnergyRate()
{	
	local float MyEnergyRate;

	MyEnergyRate = EnergyRate;
	EnergyRate = 0;
	return MyEnergyRate;
}

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	// If this is a netgame, then override defaults
	if ( Level.NetMode != NM_StandAlone )
	{
		LevelValues[3] = mpAugValue;
		 AugmentationLocation = LOC_Arm;
	}
}

defaultproperties
{
     mpAugValue=25.000000
     bAutomatic=True
     EnergyRate=0.000000
     Icon=Texture'DeusExUI.UserInterface.AugIconShield'
     smallIcon=Texture'DeusExUI.UserInterface.AugIconShield_Small'
     AugmentationName="Nanoelectricity Attack System"
     Description="EMP nanovoltage generators below the skin create a nanoelectricity charge, which will shock organic targets in a non-lethal manner and temporarily disable all electronics within its area of effect, including cameras, turrets, robots and proximity mines. On highest level the nanopulse broadband assault on the command frequencies used by all bots, turrets and security cameras manufactured since 2028. The ensuing electronic storm causes the targeted bots and turrets within its radius of effect to indiscriminately attack their allies.|n|nTECH ONE: The nanocharge has a light electricity and EMP attack.|n|nTECH TWO: The nanocharge has a medium electricity and EMP attack.|n|nTECH THREE: The nanocharge has a strong electricity and EMP attack.|n|nTECH FOUR: The nanocharge has a very strong electricity attack scramble bots, turrets, cameras and proximity mines."
     MPInfo="When active, you create an electricity charge.  Energy Drain: Medium"
     LevelValues(0)=2.000000
     LevelValues(1)=4.000000
     LevelValues(2)=8.000000
     LevelValues(3)=12.000000
     AugmentationLocation=LOC_Torso
     MPConflictSlot=6
     LoopSound=None
}
