//=============================================================================
// AugVision.
//=============================================================================
class AugVision extends Augmentation;

var float mpAugValue;
var float mpEnergyDrain;

state Active
{
Begin:
}

function Activate()
{
	Super.Activate();
}

function Deactivate()
{
	Super.Deactivate();
}

simulated function float GetEnergyRate()
{	
	local float MyEnergyRate;

	MyEnergyRate = EnergyRate;
	EnergyRate = 0;
	return MyEnergyRate;
}

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( Level.NetMode != NM_StandAlone )
	{
		LevelValues[3] = mpAugValue;
		EnergyRate = mpEnergyDrain;
	}
}

defaultproperties
{
     mpAugValue=25.000000
     EnergyRate=0.000000
     Icon=Texture'DeusExUI.UserInterface.AugIconEMP'
     smallIcon=Texture'DeusExUI.UserInterface.AugIconEMP_Small'
     AugmentationName="Life-power Gainer"
     Description="The nano-magnetic wave released by the agent gain the life-power from corpses and heal the agent. Unconscious bodies gives double amount of life-power.|n|nTECH ONE: Life-power gain occurs at a normal rate.|n|nTECH TWO: Life-power gain occurs at a slightly faster rate.|n|nTECH THREE: Life-power gain occurs at a moderately faster rate.|n|nTECH FOUR: Life-power gain occurs at a significantly faster rate."
     MPInfo="When active, you can heal yourself with the corpses. Energy Drain: High"
     LevelValues(0)=10.000000
     LevelValues(1)=20.000000
     LevelValues(2)=40.000000
     LevelValues(3)=50.000000
     AugmentationLocation=LOC_Eye
     MPConflictSlot=8
     LoopSound=None
}
