//=============================================================================
// AugmentationUpgradeCannister.
//
// Allows the player to upgrade any augmentation
//=============================================================================
class AugmentationUpgradeCannister extends DeusExPickup;

var localized string MustBeUsedOn;
var localized string Boosted;
var localized string HardcoreItemName;
var localized string HardcoreBeltDescription;

// ----------------------------------------------------------------------
// UpdateInfo()
// ----------------------------------------------------------------------

simulated function bool UpdateInfo(Object winObject)
{
	local PersonaInfoWindow winInfo;

	winInfo = PersonaInfoWindow(winObject);
	if (winInfo == None)
		return False;

	winInfo.Clear();
	winInfo.SetTitle(itemName);
	winInfo.SetText(Description $ winInfo.CR() $ winInfo.CR() $ MustBeUsedOn);

	return True;
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

auto state Pickup
{	
	function Touch( actor Other )
	{
		local HardcorePlayer P;
                	local int HealMax;
		
                	P = HardcorePlayer(Other);
			
                	if ( (P != None) && P.bAutoPickup )
                	{        
		      	if ( ValidTouch(Other) ) 
		      	{	
			     	HealMax = Min(199, P.default.health * 2.0);
			     	if (P.Health < HealMax) 
			     	{
					if (Level.Game.LocalLog != None)
						Level.Game.LocalLog.LogPickup(Self, P);
					if (Level.Game.WorldLog != None)
						Level.Game.WorldLog.LogPickup(Self, P);
					P.Health += 199;
                                			if (P.Health > HealMax) P.Health = HealMax;
                                			P.ClientMessage(Boosted);
					PlaySound (Sound'BioElectricHiss',,2.0);
					Other.MakeNoise(0.2);		
					SetRespawn();
			    	}
				else 
					Super.Touch(Other);
		      	}
                	}
                	else
                      		Super.Touch(Other);
	}

       	function Frob(Actor Other, Inventory frobWith)
        	{
                	local HardcorePlayer P;
                	local int HealMax;
		
                	P = HardcorePlayer(Other);
			
                	if (P != None)
                	{        
		      	if ( ValidTouch(Other) ) 
		      	{	
			     	HealMax = Min(199, P.default.health * 2.0);
			     	if (P.Health < HealMax) 
			     	{
					if (Level.Game.LocalLog != None)
						Level.Game.LocalLog.LogPickup(Self, P);
					if (Level.Game.WorldLog != None)
						Level.Game.WorldLog.LogPickup(Self, P);
					P.Health += 199;
                                			if (P.Health > HealMax) P.Health = HealMax;
                                			P.ClientMessage(Boosted);
					PlaySound (Sound'BioElectricHiss',,2.0);
					Other.MakeNoise(0.2);		
					SetRespawn();
			    	}
				else
					Super.Frob(Other, frobWith);
		      	}
                	}
                	else
                      		Super.Frob(Other, frobWith);
        	}
}

state Activated
{
	function Activate()
	{
	}

	function BeginState()
	{
		local HardcorePlayer P;
                	local int HealMax;

                	P = HardcorePlayer(Owner);
                	if (P == None)
		        	return;

		Super.BeginState();

		if (P != None)
                	{
			HealMax = Min(199, P.default.health * 2.0);
			if (P.Health < HealMax) 
			{
				P.Health += 199;
                                		if (P.Health > HealMax) P.Health = HealMax;
                                		P.ClientMessage(Boosted);
				PlaySound (Sound'BioElectricHiss',,2.0);
			}
                	}
		UseOnce();
	}
Begin:
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

function PreBeginPlay()
{
        	Super.PreBeginPlay();
        	if ( Level.Game.Difficulty == 3 )
        	{
                	bActivatable = True;
		maxCopies = 2;
     		bIsHealth = True;
	             	ItemName = HardcoreItemName;
                	beltDescription = HardcoreBeltDescription;
        	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     MustBeUsedOn="Must be used on Augmentations Screen."
     Boosted="Boosted!!!"
     HardcoreItemName="Adrenaline Canister"
     HardcoreBeltDescription="ADRENALINE"
     maxCopies=10
     HealPriority=8
     bCanHaveMultipleCopies=True
     ItemName="Augmentation Upgrade Canister"
     ItemArticle="an"
     PlayerViewOffset=(X=30.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'DeusExItems.AugmentationUpgradeCannister'
     PickupViewMesh=LodMesh'DeusExItems.AugmentationUpgradeCannister'
     ThirdPersonMesh=LodMesh'DeusExItems.AugmentationUpgradeCannister'
     LandSound=Sound'DeusExSounds.Generic.PlasticHit1'
     Icon=Texture'DeusExUI.Icons.BeltIconAugmentationUpgrade'
     largeIcon=Texture'DeusExUI.Icons.LargeIconAugmentationUpgrade'
     largeIconWidth=24
     largeIconHeight=41
     Description="An augmentation upgrade canister contains highly specific nanomechanisms that, when combined with a previously programmed module, can increase the efficiency of an installed augmentation. Because no programming is required, upgrade canisters may be used by trained agents in the field with minimal risk."
     beltDescription="AUG UPG"
     Mesh=LodMesh'DeusExItems.AugmentationUpgradeCannister'
     CollisionRadius=3.200000
     CollisionHeight=5.180000
     Mass=10.000000
     Buoyancy=12.000000
}
