//=============================================================================
// BadDenton.
//=============================================================================
class BadDenton extends HumanMilitary;

function PostBeginPlay()
{
        	Super.PostBeginPlay();
        	DrawShield();
        	PlaySound(Sound'CloakDown');
}

function float ShieldDamage(Name damageType)
{
	if ( IgnoreDamageType(damageType) )
		return 0.0;
	else if ( (damageType == 'Flamed') || (damageType == 'Poison') || (damageType == 'PoisonEffect') )
		return 0.25;
	else if ( (damageType == 'KnockedOut') || (damageType == 'Fell') )
		return 0.5;
	
	else
		return Super.ShieldDamage(damageType);
}


function GotoDisabledState(name damageType, EHitLocation hitPos)
{
	if ( !bCollideActors && !bBlockActors && !bBlockPlayers )
		return;
	else if ( !IgnoreDamageType(damageType) && CanShowPain() )
		TakeHit(hitPos);
	else
		GotoNextState();
}

function bool IgnoreDamageType(Name damageType)
{
	if ( (damageType == 'TearGas') || (damageType == 'PoisonGas') )
		return True;
	else
		return False;
}

function Carcass SpawnCarcass()
{
	if (bStunned)
		return Super.SpawnCarcass();

	Explode();

	return None;
}

function Explode()
{
	local SphereEffect sphere;
	local ScorchMark s;
	local ExplosionLight light;
	local int i;
	local float explosionDamage;
	local float explosionRadius;
	local DeusExFragment ss;

	explosionDamage = 100;
	explosionRadius = 256;

	// alert NPCs that I'm exploding
	AISendEvent('LoudNoise', EAITYPE_Audio, , explosionRadius*16);
	PlaySound(Sound'EMPGrenadeExplode', SLOT_None,,, explosionRadius*16);

	// draw a pretty explosion
	light = Spawn(class'ExplosionLight',,, Location);
	if (light != None)
		light.size = 4;

	Spawn(class'ExplosionSmall',,, Location + 2*VRand()*CollisionRadius);
	Spawn(class'ExplosionMedium',,, Location + 2*VRand()*CollisionRadius);
	Spawn(class'ExplosionMedium',,, Location + 2*VRand()*CollisionRadius);
	Spawn(class'ExplosionLarge',,, Location + 2*VRand()*CollisionRadius);

	sphere = Spawn(class'SphereEffect',,, Location);
	if (sphere != None)
		sphere.size = explosionRadius / 32.0;

	// spawn a mark
	s = spawn(class'ScorchMark', Base,, Location-vect(0,0,1)*CollisionHeight, Rotation+rot(16384,0,0));
	if (s != None)
	{
		s.DrawScale = FClamp(explosionDamage/30, 0.1, 3.0);
		s.ReattachDecal();
	}

	// spawn some rocks and flesh fragments
	for (i=0; i<explosionDamage/6; i++)
	{
		if (FRand() < 0.3)
			spawn(class'Rockchip',,,Location);
		else
			spawn(class'FleshFragment',,,Location);

		ss = Spawn(class'MetalFragment', Owner);

		if (ss != None)
		{
			ss.Instigator = Instigator;
			ss.CalcVelocity(Velocity, ExplosionRadius);
			ss.DrawScale = 0.5;
			ss.Skin = GetMeshTexture();
			if (FRand() < 0.75)
				ss.bSmoking = True;
		}
	}

	HurtRadius(explosionDamage, explosionRadius, 'Exploded', explosionDamage*100, Location);
}

function FireWeapon()
{
	Super.FireWeapon();
	if ( Level.Game.Difficulty < 3 )
	{
		if ( ((Enemy != None) && Enemy.bIsPlayer) && (FRand() < 0.25) )
			if ( VSize(Enemy.Location - Location) < 450 )
				ReleaseShockBeam();
	}
}

function ReleaseShockBeam()
{
	local int i;
	local NanoEmitter ShockBeam;
	
	for (i=0; i<3; i++)
	{
		ShockBeam = Spawn( Class'NanoEmitter',Self,,Location + vect(0,0,1) * 100 );
		if ( ShockBeam != None )
		{
			ShockBeam.damageAmount = 5;
			ShockBeam.Instigator = Self;
			ShockBeam.SetBase(Self);
			ShockBeam.SetLocation(Location);
			ShockBeam.SetRotation(ViewRotation);
			ShockBeam.LifeSpan = 0.5;
			ShockBeam.TurnOn();
			ShockBeam.RemoteRole = ROLE_None;
		}
	}
}

function Gasp()
{
	PlaySound(sound'MechHit1', SLOT_Pain,,,, RandomPitch());
}

function PlayTakeHitSound(int Damage, name damageType, int Mult)
{
	local Sound hitSound;
	local float volume;

	if ( Level.TimeSeconds - LastPainSound < 0.25 )
		return;
	if ( Damage <= 0 )
		return;

	LastPainSound = Level.TimeSeconds;

	if ( FRand() > 0.5 )
		hitSound = HitSound1;
	else
		hitSound = HitSound2;
	volume = FMax(Mult*TransientSoundVolume, Mult*2.0);

	SetDistressTimer();
	PlaySound(hitSound, SLOT_Pain, volume,,, RandomPitch());
	if ( (hitSound != None) && bEmitDistress )
		AISendEvent('Distress', EAITYPE_Audio, volume);
}

function PlayDyingSound()
{
	SetDistressTimer();
	if ( FRand() > 0.5 )
		PlaySound(Die, SLOT_Pain,,,, RandomPitch());
	else
		PlaySound(Sound'MechUnconscious', SLOT_Pain,,,, RandomPitch());

	AISendEvent('LoudNoise', EAITYPE_Audio);

	if ( bEmitDistress )
		AISendEvent('Distress', EAITYPE_Audio);
}

function PlayDying(name damageType, vector hitLoc)
{
	local Vector X, Y, Z;
	local float dotp;

	if (Region.Zone.bWaterZone)
		PlayAnimPivot('WaterDeath',, 0.1);
	else if (bSitting) 
		PlayAnimPivot('DeathFront',, 0.1);
	else
	{
		GetAxes(Rotation, X, Y, Z);
		dotp = (Location - HitLoc) dot X;

		// die from the correct side
		if (dotp < 0.0)		
			PlayAnimPivot('DeathBack',, 0.1);
		else				
			PlayAnimPivot('DeathFront',, 0.1);
	}

	if ((damageType == 'Stunned') || (damageType == 'KnockedOut') ||
	    (damageType == 'Poison') || (damageType == 'PoisonEffect'))
	{
		bStunned = True;
		PlaySound(Sound'MechUnconscious', SLOT_Pain,,,, RandomPitch());
	}
	else
	{
		bStunned = False;
		PlayDyingSound();
	}
}

defaultproperties
{
     JumpSound=Sound'DeusEx.Player.MechJump'
     Aggressiveness=0.800000
     BaseAccuracy=-0.250000
     bCanCommunicate=False
     CarcassType=Class'DeusEx.BadDentonCarcass'
     WalkingSpeed=0.120000
     bShowPain=False
     AvoidAccuracy=0.950000
     HarmAccuracy=0.950000
     CrouchRate=0.100000
     CloseCombatMult=1.000000
     SurprisePeriod=0.000000
     BaseAssHeight=-23.000000
     InitialInventory(0)=(Inventory=Class'DeusEx.WeaponNanoSword')
     BurnPeriod=0.000000
     GroundSpeed=300.000000
     AccelRate=2048.000000
     JumpZ=220.000000
     PeripheralVision=-0.200000
     HearingThreshold=0.050000
     Health=350
     Skill=1.000000
     HitSound1=Sound'DeusEx.Player.MechHit1'
     HitSound2=Sound'DeusEx.Player.MechHit2'
     Die=Sound'DeusEx.Player.MechDie'
     CombatStyle=0.950000
     HealthHead=350
     HealthTorso=350
     HealthLegLeft=350
     HealthLegRight=350
     HealthArmLeft=350
     HealthArmRight=350
     Mesh=LodMesh'DeusExCharacters.GM_Trench'
     MultiSkins(0)=Texture'DeusExDeco.Skins.DentonCloneTex1'
     MultiSkins(1)=Texture'DeusExCharacters.Skins.JCDentonTex2'
     MultiSkins(2)=Texture'DeusExCharacters.Skins.JCDentonTex3'
     MultiSkins(3)=Texture'DeusExDeco.Skins.DentonCloneTex1'
     MultiSkins(4)=Texture'DeusExCharacters.Skins.JCDentonTex1'
     MultiSkins(5)=Texture'DeusExCharacters.Skins.JCDentonTex2'
     MultiSkins(6)=Texture'DeusExCharacters.Skins.FramesTex4'
     MultiSkins(7)=Texture'DeusExCharacters.Skins.LensesTex5'
     CollisionRadius=20.000000
     CollisionHeight=47.500000
     BindName="MJ12Commando"
     FamiliarName="Augmented Merc"
     UnfamiliarName="Augmented Merc"
     bVisionImportant=False
}
