//=============================================================================
// BallisticArmor.
//=============================================================================
class BallisticArmor extends ChargedPickup;

var ArmorEffect MyEffect;

simulated function PreBeginPlay()
{
       	if ( Level.NetMode == NM_Standalone ) 
	{
		if ( !Level.Game.bDeathMatch )
       			bDifficulty3 = False; 
	}

       	Super.PreBeginPlay();
       	if ( ((Level.Game != None) && Level.Game.bDeathMatch) || (Level.NetMode != NM_Standalone) )
       	{
            		ArmorAbsorption = 100;
            		AmbientGlow = 255;
       	}
}

function PickupFunction(Pawn Other)
{
       	if ( Level.Game.bDeathMatch || (Level.NetMode != NM_Standalone) )
       	{
            		MyEffect = Spawn(class'ArmorEffect', Other,,Other.Location, Other.Rotation); 
            		MyEffect.Mesh = Owner.Mesh;
            		MyEffect.DrawScale = Owner.Drawscale;
		return;	
       	}
	ApplySkillUpgrade(Other);
}

simulated function Destroyed()
{
	if ( MyEffect != None )
		MyEffect.Destroy();
	Super.Destroyed();
}

defaultproperties
{
     skillNeeded=Class'DeusEx.SkillEnviro'
     EffectTexture=FireTexture'Effects.liquid.Virus_SFX'
     MaxCharge=200
     ChargedIcon=Texture'DeusExUI.Icons.ChargedIconArmorBallistic'
     bCanHaveMultipleCopies=False
     ExpireMessage="Ballistic Armor power supply used up"
     bAutoActivate=True
     ItemName="Ballistic Armor"
     ItemArticle="some"
     RespawnTime=90.000000
     PlayerViewOffset=(X=30.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'DeusExItems.BallisticArmor'
     PickupViewMesh=LodMesh'DeusExItems.BallisticArmor'
     ThirdPersonMesh=LodMesh'DeusExItems.BallisticArmor'
     Charge=200
     ArmorAbsorption=50
     bIsAnArmor=True
     AbsorptionPriority=7
     MaxDesireability=3.000000
     LandSound=Sound'DeusExSounds.Generic.PaperHit2'
     Icon=Texture'DeusExUI.Icons.BeltIconArmorBallistic'
     largeIcon=Texture'DeusExUI.Icons.LargeIconArmorBallistic'
     largeIconWidth=34
     largeIconHeight=49
     Description="Ballistic armor is manufactured from electrically sensitive polymer sheets that intrinsically react to the violent impact of a bullet or an explosion by 'stiffening' in response and absorbing the majority of the damage.  These polymer sheets must be charged before use; after the charge has dissipated they lose their reflexive properties and should be recharged."
     beltDescription="BAL ARMOR"
     Mesh=LodMesh'DeusExItems.BallisticArmor'
     CollisionRadius=11.500000
     CollisionHeight=13.810000
     Mass=40.000000
     Buoyancy=30.000000
}
