//=============================================================================
// Baton.
//=============================================================================
class Baton extends DeusExProjectile;

var float		mpDamage;
var int		mpAccurateRange;
var int		mpMaxRange;

simulated function Tick(float deltaTime)
{
	local Rotator rot;
	
	Super.Tick(deltaTime);

	if (Level.Netmode != NM_DedicatedServer)
	{
		rot = Rotation;
		rot.Roll += 16384;
		rot.Pitch -= 16384;
		SetRotation(rot);
	}
}

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();
	
	if ( Level.Game.bDeathMatch )
	{
		Damage = mpDamage;
		AccurateRange = mpAccurateRange;
		MaxRange = mpMaxRange;
	}
}

simulated function Destroyed()
{
	Spawn (spawnWeaponClass);
	Super.Destroyed();
}

defaultproperties
{
     mpDamage=45.000000
     mpAccurateRange=1200
     mpMaxRange=1600
     DamageType=KnockedOut
     spawnWeaponClass=Class'DeusEx.WeaponBaton'
     bIgnoresNanoDefense=True
     ItemName="Baton"
     ItemArticle="a"
     speed=1000.000000
     MaxSpeed=1500.000000
     Damage=30.000000
     MomentumTransfer=1000
     ImpactSound=Sound'DeusExSounds.Weapons.BatonHitFlesh'
     Mesh=LodMesh'DeusExItems.BatonPickup'
     CollisionRadius=14.000000
     CollisionHeight=3.000000
}
