//=============================================================================
// BioGas.  
//=============================================================================
class BioGelGas extends Effects;

var int numBlobs;
var vector SurfaceNormal;

replication
{
	unreliable if( Role==ROLE_Authority )
		numBlobs, SurfaceNormal;
}

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();
	SetTimer(0.01, false);
}

simulated function Timer()
{
	local GreenBlobs GB;
        	local BioCloud BC;
	local int j;

	if ( (Level.NetMode != NM_DedicatedServer) && (numBlobs > 0) && Level.bHighDetailMode && !Level.bDropDetail )
	{
		numBlobs = FMin(numBlobs, 5);
		for (j=0; j<numBlobs; j++) 
		{
			GB = Spawn(class'GreenBlobs',,,Location+SurfaceNormal*(FRand()*8-4));
			if (GB != None)
			{
				GB.SetUp(SurfaceNormal);
				GB.RemoteRole = ROLE_None;
			}
		}

                	BC = Spawn(class'BioCloud',,,Location+SurfaceNormal*(FRand()*8-4));
		if (BC != None)
		        BC.RemoteRole = ROLE_None;
	}
}

defaultproperties
{
     numBlobs=8
     LifeSpan=0.300000
     LightHue=91
     LightRadius=4
}
