//=============================================================================
// BioGlob
//=============================================================================
class BioGlob extends BioProj;

var int NumSplash;
var vector SpawnPoint;

auto state Flying
{
        simulated function HitWall(vector HitNormal, actor Wall)
        {
	   local vector TraceNorm, TraceLoc, Extent;
	   local actor HitActor;

		if (bStickToWall)
		{
		  SetPhysics(PHYS_None);		
		  Velocity = vect(0,0,0);
		  Acceleration = vect(0,0,0);
		  PlayAnim('Hit');
                  bStuck = True;
                  SurfaceNormal = HitNormal;
                  LoopAnim('Flying',0.1);
                  if ( Level.NetMode != NM_DedicatedServer )
		     spawn(class'BioDecal',,,Location, rotator(SurfaceNormal));
                  if ( DrawScale > 1.5 )
			NumSplash = int(2 * DrawScale) - 1;
		  SpawnPoint = Location + 5 * HitNormal;
		  DrawScale = FMin(DrawScale, 3.0);
		  if ( NumSplash > 0 )
		  {
			SpawnSplash();
			if ( NumSplash > 0 )
				SpawnSplash();
                        if ( NumSplash > 0 )
				SpawnSplash();
                        if ( NumSplash > 0 )
				SpawnSplash();
		  }          				            
			// MBCODE: Do this only on server side
			if ( Role == ROLE_Authority )
			{
                          if (Level.NetMode != NM_Standalone)
                                 SetTimer(5.0,False);

				if (Wall.IsA('Mover'))
				{
					SetBase(Wall);
					Wall.TakeDamage(Damage, Pawn(Owner), Wall.Location, MomentumTransfer*Normal(Velocity), damageType);
				}
			}
		}

		if (Wall.IsA('BreakableGlass'))
			bDebris = False;

		SpawnEffects(Location, HitNormal, Wall);

		Super.HitWall(HitNormal, Wall);
	}
}

function SpawnSplash()
{
	local vector Start;
               
	NumSplash--;
	Start = SpawnPoint + 4 * VRand(); 
	Spawn(class'BioSplash',,,Start,Rotator(Start - Location));
}

defaultproperties
{
     mpDamage=40.000000
     speed=700.000000
     Damage=20.000000
     MomentumTransfer=30000
     CollisionRadius=1.500000
     CollisionHeight=1.500000
}
