//=============================================================================
// BioGel.   
//=============================================================================
class BioProj extends DeusExProjectile;

var vector SurfaceNormal;	
var int numBio;
var float mpDamage;
var   float time;         
var() float WallTime;    
var   bool  bExploded;

simulated function Tick(float deltaTime)
{
    	Super.Tick(deltaTime);

    	if(bStuck)
    	{
		time += deltaTime;
        		if (time % 0.3 > 0.25) 
        		{          
             			if (time > WallTime && !bExploded)
             			{
                   			PlaySound(MiscSound, SLOT_None, 1.5,, Max(blastRadius*24, 1024));
                   			DrawExplosionEffects(Location, Location);
                   			bExploded = true;
                   			HurtRadius(damage * Drawscale, FMin(250, DrawScale * 75), 'Poison', MomentumTransfer * Drawscale, Location);
                   			GotoState('Exploding');
	           			return;
             			}
        		}
    	}
    	else
        		LoopAnim('Flying',0.4);
}

simulated function DrawExplosionEffects(vector HitLocation, vector HitNormal)
{
   	local BioGelGas f;

      	f = spawn(class'BioGelGas',,,Location + SurfaceNormal*8); 

      	if (f != None)
               	{
         		f.RemoteRole = ROLE_None;
         		f.numBlobs = numBio;
	    	if ( numBio > 0 )
			f.SurfaceNormal = SurfaceNormal;
      	}
}

function SpawnBlood(Vector HitLocation, Vector HitNormal)
{
	local int i;
        	local BioGelGas f;

	f = spawn(class'BioGelGas',,,Location + SurfaceNormal*8); 
	f.numBlobs = numBio;
	if ( numBio > 0 )
		f.SurfaceNormal = SurfaceNormal;	
	PlaySound (MiscSound,,1.5 * DrawScale);	
    
}

auto simulated state Flying
{
       	simulated function ProcessTouch (Actor Other, Vector HitLocation)
       	{
		if (bStuck)
			return;

		if ((Other != instigator) && (DeusExProjectile(Other) == None) && (Other != Owner))
		{
			damagee = Other;
			Explode(HitLocation, Normal(HitLocation-damagee.Location));

                   		if (Role == ROLE_Authority)
		   	{
                     			if (damagee.IsA('Pawn') || damagee.IsA('Decoration') || damagee.IsA('Projectile')) 
                       				SpawnBlood(HitLocation, Normal(HitLocation-damagee.Location));
        	   		}
		} 
	}

	simulated function HitWall(vector HitNormal, actor Wall)
	{
                		local vector TraceNorm, TraceLoc, Extent;
	        	local actor HitActor;

		if (bStickToWall)
		{
			SetPhysics(PHYS_None);		
		    	Velocity = vect(0,0,0);
		    	Acceleration = vect(0,0,0);
		    	PlayAnim('Hit');
                    		bStuck = True;
                    		SurfaceNormal = HitNormal;
                    		LoopAnim('Flying',0.1);
                    		if ( Level.NetMode != NM_DedicatedServer )
		         		spawn(class'BioDecal',,,Location, rotator(SurfaceNormal));
                             				            
			if ( Role == ROLE_Authority )
			{
                          			if (Level.NetMode != NM_Standalone)
                                			SetTimer(5.0,False);

				if (Wall.IsA('Mover'))
				{
					Wall.TakeDamage(Damage, Pawn(Owner), Wall.Location, MomentumTransfer*Normal(Velocity), damageType);
					if ( Wall.IsA('DeusExMover') &&  DeusExMover(Wall).bDestroyed )
						BlowUp();
					else	
						SetBase(Wall);
				}
			}
		}

		if (Wall.IsA('BreakableGlass'))
			bDebris = False;

		SpawnEffects(Location, HitNormal, Wall);

		Super.HitWall(HitNormal, Wall);
	}

        	simulated function BeginState()
	{	
           		if ( Role == ROLE_Authority )
		{
			Velocity = Vector(Rotation) * Speed;
                        		Velocity.Z += 120;
		}
		if ( Level.NetMode != NM_DedicatedServer )
			RandSpin(100000);
		LoopAnim('Flying',0.4);
		
	}
}

simulated function BlowUp()
{
	/*Disable('Tick');*/
	PlaySound(MiscSound, SLOT_None, 1.5,, Max(blastRadius*24, 1024));
                  DrawExplosionEffects(Location, Location);
                  bExploded = true;
                  HurtRadius(damage * Drawscale, FMin(250, DrawScale * 75), 'Poison', MomentumTransfer * Drawscale, Location);
                  GotoState('Exploding');
}

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();
	
	if ( ((Level.Game != None) && Level.Game.bDeathMatch) || (Level.NetMode != NM_Standalone) )
	{
		Damage = mpDamage;
		return;
	}
	if ( Level.Game.Difficulty == 3 )
		Damage = mpDamage;
}

function Frob(Actor Frobber, Inventory frobWith)
{
}

defaultproperties
{
     numBio=9
     mpDamage=25.000000
     WallTime=3.500000
     bStickToWall=True
     blastRadius=1.000000
     DamageType=Poison
     AccurateRange=640
     maxRange=1280
     bIgnoresNanoDefense=True
     ItemName="Toxic Bolt"
     ItemArticle="a"
     speed=840.000000
     MaxSpeed=1500.000000
     Damage=15.000000
     MomentumTransfer=5000
     ImpactSound=Sound'DeusEx.Weapons.BioHit'
     MiscSound=Sound'DeusEx.Weapons.BioExp'
     AnimSequence=Flying
     Style=STY_Translucent
     Texture=Texture'DeusExDeco.Skins.AlarmLightTex5'
     Skin=Texture'DeusExDeco.Skins.AlarmLightTex5'
     Mesh=LodMesh'DeusEx.BioGelm'
     DrawScale=1.500000
     AmbientGlow=10
     bUnlit=True
     bMeshEnviroMap=True
     CollisionRadius=1.000000
     CollisionHeight=1.000000
     LightType=LT_Steady
     LightEffect=LE_NonIncidence
     LightBrightness=100
     LightHue=91
     LightRadius=1
     bBounce=True
}
