//=============================================================================
// BotInfo.
//=============================================================================
class BotInfo extends Info
	config(User);

var() config bool bAdjustSkill;
var() config bool bRandomOrder;
var   config byte Difficulty;
var   config class<Bot> botClasses[25];
var   class<Bot> TeamBotClasses[2];
var() config localized string BotNames[16];
var   byte ConfigUsed[16];
var   localized string Skills[8];
var   string DesiredName;
var   int PlayerKills, PlayerDeaths;
var   float AdjustedDifficulty;

function PreBeginPlay()
{
	//DON'T Call parent prebeginplay
}

function AdjustSkill(Bot B, bool bWinner)
{
	local float BotSkill;

	BotSkill = B.Skill;
	if ( !b.bNovice )
		BotSkill += 4;

	if ( bWinner )
	{
		PlayerKills += 1;
		AdjustedDifficulty = FMax(0, AdjustedDifficulty - 2/Min(PlayerKills, 10));
		if ( BotSkill > AdjustedDifficulty )
			B.Skill = AdjustedDifficulty;
		if ( B.Skill < 4 )
		{
			B.bNovice = true;
			if ( B.Skill > 3 )
			{
				B.Skill = 3;
				B.bThreePlus = true;
			}
		}
		else
		{
			B.Skill -= 4;
			B.bNovice = false;
		}
	}
	else
	{
		PlayerDeaths += 1;
		AdjustedDifficulty += FMin(7,2/Min(PlayerDeaths, 10));
		if ( BotSkill < AdjustedDifficulty )
			B.Skill = AdjustedDifficulty;
		if ( B.Skill < 4 )
		{
			B.bNovice = true;
			if ( B.Skill > 3 )
			{
				B.Skill = 3;
				B.bThreePlus = true;
			}
		}
		else
		{
			B.Skill -= 4;
			B.bNovice = false;
		}
	}
	if ( abs(AdjustedDifficulty - Difficulty) >= 1 )
	{
		Difficulty = AdjustedDifficulty;
		SaveConfig();
	}
}

function class<Bot> GetBotClass(int n)
{
	return BotClasses[n];
}

function class<Bot> GetTeamBotClass(int n)
{
	return TeamBotClasses[n];
}

function SetBotSkill(Bot NewBot)
{
   NewBot.InitializeSkill(Difficulty);
   NewBot.PlayerReplicationInfo.TalkTexture = NewBot.TauntPortrait;
}

function CHIndividualize(Bot NewBot, int n, int NumBots)
{
	n = Clamp(n,0,16);
		
	if ( (BotNames[n] == "") || (ConfigUsed[n] == 1) )
		BotNames[n] = "Bot";

	Level.Game.ChangeName( NewBot, BotNames[n], false );
	if ( BotNames[n] != NewBot.PlayerReplicationInfo.PlayerName )
		Level.Game.ChangeName( NewBot, ("Bot"$NumBots), false);
        
	ConfigUsed[n] = 1;
}

function int ChooseBotInfo()
{
	local int n, start;
        
	if ( DesiredName != "" )
	{
		for ( n=0; n<16; n++ )
			if ( BotNames[n] ~= DesiredName )
			{
				DesiredName = "";
				return n;
			}
		DesiredName = "";
	}

	if ( bRandomOrder )
		n = Rand(16);
	else 
		n = 0;

	start = n;
	while ( (n < 16) && (ConfigUsed[n] == 1) )
		n++;

	if ( (n == 16) && bRandomOrder )
	{
		n = 0;
		while ( (n < start) && (ConfigUsed[n] == 1) )
			n++;
	}

	if ( n > 16 )
		n = 16;

	return n;
}

function int SelectBots()
{
    return Rand(25);
}

defaultproperties
{
     bRandomOrder=True
     Difficulty=5
     botClasses(0)=Class'DeusEx.Bot_AlexJacobson'
     botClasses(1)=Class'DeusEx.Bot_AnnaNavarre'
     botClasses(2)=Class'DeusEx.Bot_Cilia'
     botClasses(3)=Class'DeusEx.Bot_Cop'
     botClasses(4)=Class'DeusEx.Bot_GordonQuick'
     botClasses(5)=Class'DeusEx.Bot_GuntherHermann'
     botClasses(6)=Class'DeusEx.Bot_JCDenton'
     botClasses(7)=Class'DeusEx.Bot_Jock'
     botClasses(8)=Class'DeusEx.Bot_Lebedev'
     botClasses(9)=Class'DeusEx.Bot_LumPath'
     botClasses(10)=Class'DeusEx.Bot_Maggie'
     botClasses(11)=Class'DeusEx.Bot_Smuggler'
     botClasses(12)=Class'DeusEx.Bot_MIB'
     botClasses(13)=Class'DeusEx.Bot_MJ12'
     botClasses(14)=Class'DeusEx.Bot_Terrorist'
     botClasses(15)=Class'DeusEx.Bot_PaulDenton'
     botClasses(16)=Class'DeusEx.Bot_Researcher'
     botClasses(17)=Class'DeusEx.Bot_RiotCop'
     botClasses(18)=Class'DeusEx.Bot_Sailor'
     botClasses(19)=Class'DeusEx.Bot_HowardStrong'
     botClasses(20)=Class'DeusEx.Bot_MaxChen'
     botClasses(21)=Class'DeusEx.Bot_TracerTong'
     botClasses(22)=Class'DeusEx.Bot_Unatco'
     botClasses(23)=Class'DeusEx.Bot_WaltonSimons'
     botClasses(24)=Class'DeusEx.Bot_WIB'
     TeamBotClasses(0)=Class'DeusEx.Bot_UN'
     TeamBotClasses(1)=Class'DeusEx.Bot_NSF'
     BotNames(0)="Calameth"
     BotNames(1)="Lockdown"
     BotNames(2)="Bart"
     BotNames(3)="Malakai"
     BotNames(4)="Slain"
     BotNames(5)="Drimacus"
     BotNames(6)="Nikolai"
     BotNames(7)="Vector"
     BotNames(8)="Raynor"
     BotNames(9)="Blake"
     BotNames(10)="Karag"
     BotNames(11)="Zenith"
     BotNames(12)="Dovienya"
     BotNames(13)="Cannonball"
     BotNames(14)="Kosak"
     BotNames(15)="Barak"
     Skills(0)="Untrained"
     Skills(1)="Trained"
     Skills(2)="Experienced"
     Skills(3)="Skilled"
     Skills(4)="Advanced"
     Skills(5)="Masterful"
     Skills(6)="Inhuman"
     Skills(7)="Godlike"
}
