//=============================================================================
// BotPlayer.
//=============================================================================
class BotPlayer expands Human
      abstract;

var NavigationPoint StartSpot;
var Texture TauntPortrait;
var EBarkModes TauntType;
var String myClientMessage;
var Float myMsgTime;

event TravelPostAccept()
{
        	Super.TravelPostAccept();
}

simulated event RenderOverlays( canvas Canvas )
{
        	Super(PlayerPawnExt).RenderOverlays(Canvas);
}

function SendGlobalMessage(PlayerReplicationInfo Recipient, name MessageType, byte MessageID, float Wait)
{
        	SendVoiceMessage(PlayerReplicationInfo, Recipient, MessageType, MessageID, 'GLOBAL');
}

function SendVoiceMessage(PlayerReplicationInfo Sender, PlayerReplicationInfo Recipient, name messagetype, byte messageID, name broadcasttype)
{
        	local Pawn P;

	if ( Level.Netmode != NM_Standalone )
		return;

        	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
              		if ( P.IsA('DeusExPlayer') )
                  		DeusExPlayer(P).StartAIBarkConversation(Self, TauntType);
}

function bool IsHighlighted(actor A)
{
	return False;
}

function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
						Vector momentum, name damageType)
{
	local int actualDamage;
        	local bool bAlreadyDead;

	if ( Role < ROLE_Authority )
	{
		log(self$" client damage type "$damageType$" by "$instigatedBy);
		return;
	}
	
	bAlreadyDead = (Health <= 0);

	if (Physics == PHYS_None)
		SetMovementPhysics();
	if (Physics == PHYS_Walking)
		momentum.Z = FMax(momentum.Z, 0.4 * VSize(momentum));
	if ( instigatedBy == self )
		momentum *= 0.6;
	momentum = momentum/Mass;
	AddVelocity( momentum ); 
        
        	if ( (damageType == 'NanoVirus') || (damageType == 'TearGas') || (damageType == 'EMP')) 
		return;
        
	actualDamage = Level.Game.ReduceDamage(Damage, DamageType, self, instigatedBy);

	if (ReducedDamageType == 'All') //God mode
		actualDamage = 0;
	else if (Inventory != None) //then check if carrying armor
		actualDamage = Inventory.ReduceDamage(actualDamage, DamageType, HitLocation);
	else
		actualDamage = Damage;
		
	if ( Level.Game.DamageMutator != None )
		Level.Game.DamageMutator.MutatorTakeDamage( ActualDamage, Self, InstigatedBy, HitLocation, Momentum, DamageType );
	Health -= actualDamage;
	if (CarriedDecoration != None)
		DropDecoration();
	if ( HitLocation == vect(0,0,0) )
		HitLocation = Location;
	if (Health > 0)
	{
		if ( (instigatedBy != None) && (instigatedBy != Self) )
			damageAttitudeTo(instigatedBy);
		PlayHit(actualDamage, hitLocation, damageType, Momentum);
	}
	else if ( !bAlreadyDead )
	{
		NextState = '';
		PlayDeathHit(actualDamage, hitLocation, damageType, Momentum);
		if ( actualDamage > mass )
			Health = -1 * actualDamage;
		if ( (instigatedBy != None) && (instigatedBy != Self) )
			damageAttitudeTo(instigatedBy);
		Died(instigatedBy, damageType, HitLocation);
	}
	else
	{
		HidePlayer();
		GotoState('Dying');
		
	}
	MakeNoise(1.0); 
}

simulated function PlayFootStep()
{
	local Sound stepSound;
	local float rnd;
	local float speedFactor, massFactor;
	local float volume, pitch, range;
	local float radius, mult;
	local float volumeMultiplier;
	
	rnd = FRand();

	volumeMultiplier = 1.0;
	if (IsInState('PlayerSwimming') || (Physics == PHYS_Swimming))
	{
		volumeMultiplier = 0.5;
		if (rnd < 0.5)
			stepSound = Sound'Swimming';
		else
			stepSound = Sound'Treading';
	}
	else if (FootRegion.Zone.bWaterZone)
	{
		volumeMultiplier = 1.0;
		if (rnd < 0.33)
			stepSound = Sound'WaterStep1';
		else if (rnd < 0.66)
			stepSound = Sound'WaterStep2';
		else
			stepSound = Sound'WaterStep3';
	}
	else
	{
		switch(FloorMaterial)
		{
			case 'Textile':
			case 'Paper':
				volumeMultiplier = 0.7;
				if (rnd < 0.25)
					stepSound = Sound'CarpetStep1';
				else if (rnd < 0.5)
					stepSound = Sound'CarpetStep2';
				else if (rnd < 0.75)
					stepSound = Sound'CarpetStep3';
				else
					stepSound = Sound'CarpetStep4';
				break;

			case 'Foliage':
			case 'Earth':
				volumeMultiplier = 0.6;
				if (rnd < 0.25)
					stepSound = Sound'GrassStep1';
				else if (rnd < 0.5)
					stepSound = Sound'GrassStep2';
				else if (rnd < 0.75)
					stepSound = Sound'GrassStep3';
				else
					stepSound = Sound'GrassStep4';
				break;

			case 'Metal':
			case 'Ladder':
				volumeMultiplier = 1.0;
				if (rnd < 0.25)
					stepSound = Sound'MetalStep1';
				else if (rnd < 0.5)
					stepSound = Sound'MetalStep2';
				else if (rnd < 0.75)
					stepSound = Sound'MetalStep3';
				else
					stepSound = Sound'MetalStep4';
				break;

			case 'Ceramic':
			case 'Glass':
			case 'Tiles':
				volumeMultiplier = 0.7;
				if (rnd < 0.25)
					stepSound = Sound'TileStep1';
				else if (rnd < 0.5)
					stepSound = Sound'TileStep2';
				else if (rnd < 0.75)
					stepSound = Sound'TileStep3';
				else
					stepSound = Sound'TileStep4';
				break;

			case 'Wood':
				volumeMultiplier = 0.7;
				if (rnd < 0.25)
					stepSound = Sound'WoodStep1';
				else if (rnd < 0.5)
					stepSound = Sound'WoodStep2';
				else if (rnd < 0.75)
					stepSound = Sound'WoodStep3';
				else
					stepSound = Sound'WoodStep4';
				break;

			case 'Brick':
			case 'Concrete':
			case 'Stone':
			case 'Stucco':
			default:
				volumeMultiplier = 0.7;
				if (rnd < 0.25)
					stepSound = Sound'StoneStep1';
				else if (rnd < 0.5)
					stepSound = Sound'StoneStep2';
				else if (rnd < 0.75)
					stepSound = Sound'StoneStep3';
				else
					stepSound = Sound'StoneStep4';
				break;
		}
	}
	if ( Level.NetMode == NM_Standalone )		
		PlaySound(stepSound, SLOT_Interact, 0.1, , 512.0, 1.0);
	else
	{
		if ( !bIsWalking )
			PlaySound(stepSound, SLOT_Interact, 0.1, , 512.0, 1.0);
	}
	if ( (Level.NetMode != NM_Client) && ((Weapon == None) || !Weapon.bPointing) )	
		MakeNoise(0.1);
}

function DoJump( optional float F )
{
	local DeusExWeapon w;
	local float scaleFactor, augLevel;

	if ( (CarriedDecoration != None) && (CarriedDecoration.Mass > 20) )
		return;
	else if ( bForceDuck || IsLeaning() )
		return;

	if ( Physics == PHYS_Walking )
	{
		if ( Role == ROLE_Authority )
			PlaySound(JumpSound, SLOT_None, 1.5, true, 1200, 1.0 - 0.1*FRand() );
		if ( (Level.Game != None) && (Level.Game.Difficulty > 0) )
			MakeNoise(0.1 * Level.Game.Difficulty);
		PlayInAir();

		Velocity.Z = JumpZ;

		if ( Base != Level )
			Velocity.Z += Base.Velocity.Z;
		SetPhysics(PHYS_Falling);
		if ( bCountJumps && (Role == ROLE_Authority) && (Inventory != None) )
			Inventory.OwnerJumped();
	}
}

function PlayDuck()
{
	if ((AnimSequence != 'Crouch') && (AnimSequence != 'CrouchWalk'))
	{
		if (IsFiring())
			PlayAnim('CrouchShoot',,0.1);
		else
			PlayAnim('Crouch',,0.1);
	}
	else
		TweenAnim('Crouch', 0.1);
}

function PlayCrawling()
{
	LoopAnim('CrouchShoot');
}

function PlayHit(float Damage, vector HitLocation, name damageType, vector Momentum)
{
	if ( (Damage > 0) && (damageType == 'Shot') || (damageType == 'Exploded') || (damageType == 'AutoShot') 
           	|| (damageType == 'SniperDeath') || (damageType == 'GrenadeDeath') )
		SpawnBlood(HitLocation, Damage);

	PlayTakeHitSound(Damage, damageType, 1);
}

function PlayDyingSound()
{
	if ( FRand() < 0.33 )
		PlaySound(sound'PlayerDie1', SLOT_Pain,,,, RandomPitch());
	else if ( FRand() < 0.67 )
		PlaySound(sound'PlayerDie2', SLOT_Pain,,,, RandomPitch());
	else 
		PlaySound(sound'PlayerDie3', SLOT_Pain,,,, RandomPitch());
}

function PlayTakeHitSound(int Damage, name damageType, int Mult)
{
	if ( Level.TimeSeconds - LastPainSound < FRand() + 0.5)
		return;

	LastPainSound = Level.TimeSeconds;

	if ( Region.Zone.bWaterZone )
	{
		if ( damageType == 'Drowned' )
		{
			if ( FRand() < 0.8 )
				PlaySound(sound'MaleDrown', SLOT_Pain, FMax(Mult * TransientSoundVolume, Mult * 2.0),,, RandomPitch());
		}
		else
			PlaySound(sound'PlayerHit1', SLOT_Pain, FMax(Mult * TransientSoundVolume, Mult * 2.0),,, RandomPitch());
	}
	else
	{
		if ( FRand() < 0.33 )
			PlaySound(sound'PlayerHit1', SLOT_Pain, FMax(Mult * TransientSoundVolume, Mult * 2.0),,, RandomPitch());
		else if ( FRand() < 0.67 )
			PlaySound(sound'PlayerHit2', SLOT_Pain, FMax(Mult * TransientSoundVolume, Mult * 2.0),,, RandomPitch());
		else 
			PlaySound(sound'PlayerHit3', SLOT_Pain, FMax(Mult * TransientSoundVolume, Mult * 2.0),,, RandomPitch());
	}
}

function Died(pawn Killer, name damageType, vector HitLocation)
{
       	if (Level.NetMode == NM_Standalone) 
              		ClearScopeView();
       	Super.Died(Killer, damageType, HitLocation);
}

function ClearScopeView()
{
       	if ( ( DeusExRootWindow(rootWindow).scopeView != None ) && DeusExRootWindow(rootWindow).scopeView.bViewVisible )
	     	DeusExRootWindow(rootWindow).scopeView.DeactivateView();
	if ( ( DeusExRootWindow(rootWindow).HUD.AugDisplay != None ) && DeusExRootWindow(rootWindow).HUD.AugDisplay.bVisionActive )
	{
		DeusExRootWindow(RootWindow).HUD.AugDisplay.bVisionActive = False;
		DeusExRootWindow(RootWindow).HUD.AugDisplay.visionBlinder = None;
	}
}

function Carcass SpawnCarcass()
{
	local DeusExCarcass carc;
	local Vector loc;

	// don't spawn a carcass if we've been gibbed
	if (Health < -80)
           		return None;

	carc = DeusExCarcass(Spawn(CarcassType));
	if (carc != None)
	{
		carc.Initfor(self);

		// move it down to the ground
		loc = Location;
		loc.z -= CollisionHeight;
		loc.z += carc.CollisionHeight;
		carc.SetLocation(loc);
                		carc.bHighlight = False;

		if (Player != None)
			carc.bPlayerCarcass = true;
		MoveTarget = carc; //for Player 3rd person views
	}
	return carc;
}

function UpdateInHand()
{
        	if (Weapon != None)
               		SetInHand(Weapon);
        	else
               		SetInHand(None);
}

exec function GetNanoSword()
{
}

exec function PrevBeltItem()
{
	local int prevGroup;
	local Inventory inv;
	local Weapon realWeapon, w, Prev;
	local bool bFoundWeapon;

	if (RestrictInput())
                 	return;

	if ( Weapon == None )
	{
		SwitchToBestWeapon();
		return;
	}
                
	prevGroup = 0;
	realWeapon = Weapon;
	if ( PendingWeapon != None )
		Weapon = PendingWeapon;
	PendingWeapon = None;
	
	for (inv=Inventory; inv!=None; inv=inv.Inventory)
	{
		w = Weapon(inv);
		if ( w != None )
		{
			if ( w.InventoryGroup == Weapon.InventoryGroup )
			{
				if ( w == Weapon )
				{
					bFoundWeapon = true;
					if ( Prev != None )
					{
						PendingWeapon = Prev;
						break;
					}
				}
				else if ( !bFoundWeapon && ((w.AmmoType == None) || (w.AmmoType.AmmoAmount>0) || (w.AmmoName == Class'AmmoNone')
                                       			 || (w.IsA('WeaponAssaultGun') && (WeaponAssaultGun(w).AltAmmoType != None) && (WeaponAssaultGun(w).AltAmmoType.AmmoAmount > 0))) )
					Prev = W;
			}
			else if ( (w.InventoryGroup < Weapon.InventoryGroup) 
					&& ((w.AmmoType == None) || (w.AmmoType.AmmoAmount>0) || (w.AmmoName == Class'AmmoNone') 
                                        			|| (w.IsA('WeaponAssaultGun') && (WeaponAssaultGun(w).AltAmmoType != None) && (WeaponAssaultGun(w).AltAmmoType.AmmoAmount > 0))) 
					&& (w.InventoryGroup >= prevGroup) )
			{
				prevGroup = w.InventoryGroup;
				PendingWeapon = w;
			}
		}
	}
	bFoundWeapon = false;
	prevGroup = Weapon.InventoryGroup;
	if ( PendingWeapon == None )
		for (inv=Inventory; inv!=None; inv=inv.Inventory)
		{
			w = Weapon(inv);
			if ( w != None )
			{
				if ( w.InventoryGroup == Weapon.InventoryGroup )
				{
					if ( w == Weapon )
						bFoundWeapon = true;
					else if ( bFoundWeapon && (PendingWeapon == None) && ((w.AmmoType == None) || (w.AmmoType.AmmoAmount>0) || (w.AmmoName == Class'AmmoNone')
                                                				|| (w.IsA('WeaponAssaultGun') && (WeaponAssaultGun(w).AltAmmoType != None) && (WeaponAssaultGun(w).AltAmmoType.AmmoAmount > 0))) )
						PendingWeapon = W;
				}
				else if ( (w.InventoryGroup > PrevGroup) 
						&& ((w.AmmoType == None) || (w.AmmoType.AmmoAmount>0) || (w.AmmoName == Class'AmmoNone')
                                                				|| (w.IsA('WeaponAssaultGun') && (WeaponAssaultGun(w).AltAmmoType != None) && (WeaponAssaultGun(w).AltAmmoType.AmmoAmount > 0))) ) 
				{
					prevGroup = w.InventoryGroup;
					PendingWeapon = w;
				}
			}
		}

	Weapon = realWeapon;
	if ( PendingWeapon == None )
		return;

	Weapon.PutDown();

}

exec function NextBeltItem()
{
	local int nextGroup;
	local Inventory inv;
	local Weapon realWeapon, w, Prev;
	local bool bFoundWeapon;

	if (RestrictInput())
                 		return;

	if ( Weapon == None )
	{
		SwitchToBestWeapon();
		return;
	}

        	nextGroup = 100;
	realWeapon = Weapon;
	if ( PendingWeapon != None )
		Weapon = PendingWeapon;
	PendingWeapon = None;

	for (inv=Inventory; inv!=None; inv=inv.Inventory)
	{
		w = Weapon(inv);
		if ( w != None )
		{
			if ( w.InventoryGroup == Weapon.InventoryGroup )
			{
				if ( w == Weapon )
					bFoundWeapon = true;
				else if ( bFoundWeapon && ((w.AmmoType == None) || (w.AmmoType.AmmoAmount>0) || (w.AmmoName == Class'AmmoNone')
                                         			|| (w.IsA('WeaponAssaultGun') && (WeaponAssaultGun(w).AltAmmoType != None) && (WeaponAssaultGun(w).AltAmmoType.AmmoAmount > 0))) )
				{
					PendingWeapon = W;
					break;
				}
			}
			else if ( (w.InventoryGroup > Weapon.InventoryGroup) 
					&& ((w.AmmoType == None) || (w.AmmoType.AmmoAmount>0) || (w.AmmoName == Class'AmmoNone')
                                        			|| (w.IsA('WeaponAssaultGun') && (WeaponAssaultGun(w).AltAmmoType != None) && (WeaponAssaultGun(w).AltAmmoType.AmmoAmount > 0))) 
					&& (w.InventoryGroup < nextGroup) )
			{
				nextGroup = w.InventoryGroup;
				PendingWeapon = w;
			}
		}
	}

	bFoundWeapon = false;
	nextGroup = Weapon.InventoryGroup;
	if ( PendingWeapon == None )
		for (inv=Inventory; inv!=None; inv=inv.Inventory)
		{
			w = Weapon(Inv);
			if ( w != None )
			{
				if ( w.InventoryGroup == Weapon.InventoryGroup )
				{
					if ( w == Weapon )
					{
						bFoundWeapon = true;
						if ( Prev != None )
							PendingWeapon = Prev;
					}
					else if ( !bFoundWeapon && (PendingWeapon == None) && ((w.AmmoType == None) || (w.AmmoType.AmmoAmount>0)
                                                 				|| (w.IsA('WeaponAssaultGun') && (WeaponAssaultGun(w).AltAmmoType != None) && (WeaponAssaultGun(w).AltAmmoType.AmmoAmount > 0))) )
						Prev = W;
				}
				else if ( (w.InventoryGroup < nextGroup) 
					&& ((w.AmmoType == None) || (w.AmmoType.AmmoAmount>0) || (w.AmmoName == Class'AmmoNone')
                                        			|| (w.IsA('WeaponAssaultGun') && (WeaponAssaultGun(w).AltAmmoType != None) && (WeaponAssaultGun(w).AltAmmoType.AmmoAmount > 0))) ) 
				{
					nextGroup = w.InventoryGroup;
					PendingWeapon = w;
				}
			}
		}

	Weapon = realWeapon;
	if ( PendingWeapon == None )
		return;

	Weapon.PutDown();
}

exec function ActivateBelt(int objectNum)
{             
        	if (RestrictInput())
                 		return;

        	SwitchWeapon(Byte(objectNum));
}

function ChangedWeapon()
{
	local Weapon OldWeapon;

	OldWeapon = Weapon;

	if (Weapon == PendingWeapon)
	{
		if ( Weapon == None )
			SwitchToBestWeapon();
		else if ( Weapon.IsInState('DownWeapon') ) 
			Weapon.BringUp();
		if ( Weapon != None )
			Weapon.SetDefaultDisplayProperties();
		Inventory.ChangedWeapon(); 
		PendingWeapon = None;
		return;
	}
	if ( PendingWeapon == None )
		PendingWeapon = Weapon;

	PlayWeaponSwitch(PendingWeapon);
	if ( (PendingWeapon != None) && (PendingWeapon.Mass > 20) && (carriedDecoration != None) )
		DropDecoration();
	if ( Weapon != None )
		Weapon.SetDefaultDisplayProperties();
		
	Weapon = PendingWeapon;
	Inventory.ChangedWeapon(); 
	if ( Weapon != None )
	{
		Weapon.RaiseUp(OldWeapon);
		if ( (Level.Game != None) && (Level.Game.Difficulty > 1) )
			MakeNoise(0.1 * Level.Game.Difficulty);		
	}
	PendingWeapon = None;
}

function ClientMessage( coerce string S, optional Name Type, optional bool bBeep )
{
        	if (Player == None)
		return;

	if (Type == '')
		Type = 'Event';

        	MyNotifyMessage(S);

        	if (Level.Netmode != NM_Standalone)
            		if (Player.Console != None)
			Player.Console.Message( PlayerReplicationInfo, S, Type );

	if (bBeep && bMessageBeep)
		PlayBeepSound();
}

function MyNotifyMessage( coerce string S )
{
        	myClientMessage = S;
        	myMsgTime = Level.Timeseconds + mpMsgDelay;
}

exec function AltFire( optional float F )
{
	bJustAltFired = true;
	if( bShowMenu || (Level.Pauser!="") || (Role < ROLE_Authority) )
	{
		if( (Role < ROLE_Authority) && (Weapon!=None) )
			bJustAltFired = Weapon.ClientAltFire(F);
		if ( !bShowMenu && (Level.Pauser == PlayerReplicationInfo.PlayerName) )
			SetPause(False);
		return;
	}
	if( Weapon!=None )
	{
		Weapon.bPointing = true;
		PlayFiring();
		Weapon.AltFire(F);
	}
}

function Landed(vector HitNormal)
{
	PlayLanded(Velocity.Z);
	LandBob = FMin(50, 0.055 * Velocity.Z); 
	TakeFallingDamage();
        	bJustLanded = true;
}

simulated function RefreshSystems(float DeltaTime)
{
	local DeusExRootWindow root;

        	if (Role == ROLE_Authority)
               		return;

        	if (LastRefreshTime < 0)
                		LastRefreshTime = 0;

        	LastRefreshTime = LastRefreshTime + DeltaTime;

        	if (LastRefreshTime < 0.25)
                		return;
      
        	root = DeusExRootWindow(rootWindow);
        	if (root != None)    
                		root.RefreshDisplay(LastRefreshTime);

        	LastRefreshTime = 0;
}

function ClientDeath()
{   
        	Super.ClientDeath();
        	myMsgTime = 0;
}

function bool AddInventory(inventory item)
{
        	return Super(Pawn).AddInventory(item);
}

function bool DeleteInventory(inventory item)
{
        	return Super(Pawn).DeleteInventory(item);
}

function Bool FindInventorySlot(Inventory anItem, optional Bool bSearchOnly)
{
        	return true;
}

function Bool FindInventorySlotXY(int invSlotsX, int invSlotsY, out int newSlotX, out int newSlotY)
{
        	return true;
}

exec function Freelance()
{
  	local Pawn P;

  	if ( (DXGame != None) && !DXGame.bTeamGame )
       		return;

  	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
	{
       		if ( P.IsA('Bot') && (Bot(P).Orders == 'Follow')
          		&& ( (Bot(P).OrderObject != None) && (Bot(P).OrderObject == Self) ) )  
       		{
	         		Bot(P).SetOrders('Freelance', None);
               			Bot(P).SupportingPlayer = None;
       		}
	}
}

function bool StartAIBarkConversation(Actor conOwner,EBarkModes barkMode)
{
	if ( bNoVoices )
		return False;
	else
		return Super.StartAIBarkConversation(conOwner, barkMode);
}

exec function ShowInventoryWindow()
{
}

exec function ShowSkillsWindow()
{
}

exec function ShowHealthWindow()
{
}

exec function ShowImagesWindow()
{
}

exec function ShowConversationsWindow()
{
}

exec function ShowAugmentationsWindow()
{
}

exec function ShowGoalsWindow()
{
}

exec function ShowLogsWindow()
{
}

exec function PrevItem()
{
}

exec function ActivateItem()
{
}

function int HealPlayer(int baseHealPoints, optional Bool bUseMedicineSkill)
{
         	return 0;	
}

function NintendoImmunityEffect( bool on )
{
}

exec function ActivateAugmentation(int num)
{
         	ViewPlayerNum(num); 
}

exec function ActivateAllAugs()
{
}

exec function AllAugs()
{
}

exec function AugAdd(class<Augmentation> aWantedAug)
{
}

exec function bool DropItem(optional Inventory inv, optional bool bDrop)
{
         	ThrowWeapon();
         	return true;
}

function GiveInitialInventory()
{
}

function UpdateDynamicMusic(float deltaTime)
{
}

function UpdateWarrenEMPField(float deltaTime)
{
}

function AddChargedDisplay(DeusExPickup item)
{
}

function RemoveChargedDisplay(DeusExPickup item)
{
}

function AddDamageDisplay(name damageType, vector hitOffset)
{
}

function Float GetLogTimeOut()
{
     	return 0.0;
}

exec function ParseRightClick()
{
}

exec function ToggleScope()
{
}

exec function Adaptive()
{
}

defaultproperties
{
     TauntType=BM_AreaSecure
     mpGroundSpeed=400.000000
     JumpSound=Sound'DeusEx.Player.PlayerJump1'
     bAutoActivate=True
     GroundSpeed=400.000000
     JumpZ=350.000000
     AirControl=0.400000
     UnderWaterTime=60.000000
     HitSound1=Sound'DeusEx.Player.PlayerHit1'
     HitSound2=Sound'DeusEx.Player.PlayerHit2'
     Land=Sound'DeusEx.Player.PlayerLand1'
     Die=Sound'DeusEx.Player.PlayerDie1'
     Mesh=LodMesh'DeusExCharacters.GM_Trench'
     Mass=100.000000
     RotationRate=(Pitch=3072,Yaw=65000,Roll=2048)
}
