//=============================================================================
// Bot_AnnaNavarre.
//=============================================================================
class Bot_AnnaNavarre extends Bot;

function Bool HasTwoHandedWeapon()
{
	return False;
}

function PlayWeaponSwitch(Weapon NewWeapon)
{
}

function SpawnGibbedCarcass()
{
  	local FleshFragment chunk;
  	local float size;
  	local vector loc;
  	local int i;
	local DeusExFragment ss;

  	size = (CollisionRadius + CollisionHeight) / 2;
  	if (size > 10.0)
  	{
		for (i=0; i<size/4.0; i++)
		{
			loc.X = (1-2*FRand()) * CollisionRadius;
			loc.Y = (1-2*FRand()) * CollisionRadius;
			loc.Z = (1-2*FRand()) * CollisionHeight;
			loc += Location;
			chunk = spawn(class'FleshFragment', None,, loc);
			if (chunk != None)
			{
				chunk.DrawScale = size / 25;
				chunk.SetCollisionSize(chunk.CollisionRadius / chunk.DrawScale, chunk.CollisionHeight / chunk.DrawScale);
				chunk.bFixedRotationDir = True;
				chunk.RotationRate = RotRand(False);
			}
			ss = Spawn(class'MetalFragment', Owner);
			if (ss != None)
			{
				ss.Instigator = Instigator;
				ss.CalcVelocity(Velocity, 256);
				ss.DrawScale = 0.5;
				ss.Skin = GetMeshTexture();
				if (FRand() < 0.75)
					ss.bSmoking = True;
			}                                                      
		}
  	}
}

function Carcass SpawnCarcass()
{
	local DeusExCarcass carc;
      	local FleshFragment chunk;
      	local float size;
      	local vector loc;
      	local int i;
	local DeusExFragment ss;
		
      	if (Gibbed('')) 
	{
		size = (CollisionRadius + CollisionHeight) / 2;
		if (size > 10.0)
		{
			for (i=0; i<size/4.0; i++)
			{
				loc.X = (1-2*FRand()) * CollisionRadius;
				loc.Y = (1-2*FRand()) * CollisionRadius;
				loc.Z = (1-2*FRand()) * CollisionHeight;
				loc += Location;
				chunk = spawn(class'FleshFragment', None,, loc);
				if (chunk != None)
				{
					chunk.DrawScale = size / 25;
					chunk.SetCollisionSize(chunk.CollisionRadius / chunk.DrawScale, chunk.CollisionHeight / chunk.DrawScale);
					chunk.bFixedRotationDir = True;
					chunk.RotationRate = RotRand(False);
				}
				ss = Spawn(class'MetalFragment', Owner);
				if (ss != None)
				{
					ss.Instigator = Instigator;
					ss.CalcVelocity(Velocity, 256);
					ss.DrawScale = 0.5;
					ss.Skin = GetMeshTexture();
					if (FRand() < 0.75)
						ss.bSmoking = True;
				}                           
			}
		}
		return None;
	}
	
	carc = DeusExCarcass(Spawn(CarcassType));

	if ( carc != None )
	{
		carc.Initfor(self);

		// move it down to the floor
		loc = Location;
		loc.z -= Default.CollisionHeight;
		loc.z += carc.Default.CollisionHeight;
		carc.SetLocation(loc);
		carc.Velocity = Velocity;
		carc.Acceleration = Acceleration;
	}
	return carc;
}

defaultproperties
{
     CarcassType=Class'DeusEx.AnnaNavarreCarcass'
     TauntPortrait=Texture'DeusEx.Taunts.an_tp'
     CampingRate=0.100000
     bIsFemale=True
     BaseEyeHeight=38.000000
     CombatStyle=0.200000
     Mesh=LodMesh'DeusExCharacters.GFM_TShirtPants'
     DrawScale=1.100000
     MultiSkins(0)=Texture'DeusExCharacters.Skins.AnnaNavarreTex0'
     MultiSkins(1)=Texture'DeusExItems.Skins.PinkMaskTex'
     MultiSkins(2)=Texture'DeusExItems.Skins.PinkMaskTex'
     MultiSkins(3)=Texture'DeusExItems.Skins.GrayMaskTex'
     MultiSkins(4)=Texture'DeusExItems.Skins.BlackMaskTex'
     MultiSkins(5)=Texture'DeusExCharacters.Skins.AnnaNavarreTex0'
     MultiSkins(6)=Texture'DeusExCharacters.Skins.PantsTex9'
     MultiSkins(7)=Texture'DeusExCharacters.Skins.AnnaNavarreTex1'
     CollisionHeight=47.299999
     BindName="AnnaNavarre"
     FamiliarName="Anna Navarre"
     UnfamiliarName="Anna Navarre"
}
